/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration.browser.selenium;

import hudson.Extension;
import hudson.model.Computer;
import hudson.plugins.selenium.configuration.browser.IeDriverServerUtils;
import hudson.plugins.selenium.configuration.browser.selenium.SeleniumBrowser;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class IEBrowser
extends SeleniumBrowser {
    private static final long serialVersionUID = 2L;
    private String driverBinaryPath;
    private transient boolean forbid64bitDriver;
    private final transient String ieDriverProperty = "webdriver.ie.driver";
    @Deprecated
    private transient String server_binary;

    @DataBoundConstructor
    public IEBrowser(int maxInstances, String version, String driverBinaryPath, boolean forbid64bitDriver) {
        super(maxInstances, version, "*iexplore");
        this.driverBinaryPath = driverBinaryPath;
        this.forbid64bitDriver = forbid64bitDriver;
    }

    @Exported
    public String getDriverBinaryPath() {
        return this.driverBinaryPath;
    }

    @Exported
    public boolean getForbid64bitDriver() {
        return this.forbid64bitDriver;
    }

    @Override
    public void initOptions(Computer c, SeleniumRunOptions opt) {
        String serverPath = IeDriverServerUtils.uploadIEDriverIfNecessary(c, this.getDriverBinaryPath(), this.getForbid64bitDriver());
        if (serverPath != null) {
            opt.getJVMArguments().put("webdriver.ie.driver", serverPath);
        }
        opt.addOptionIfSet("-browser", StringUtils.join(this.initBrowserOptions(c, opt), (String)","));
    }

    @Deprecated
    public String getServer_binary() {
        return this.server_binary;
    }

    public Object readResolve() {
        if (this.server_binary != null) {
            this.driverBinaryPath = this.server_binary;
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends SeleniumBrowser.SeleniumBrowserDescriptor {
        @Override
        public int getMaxInstances() {
            return 1;
        }

        public String getDisplayName() {
            return "Internet Explorer";
        }
    }
}

