/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration.browser.selenium;

import hudson.Extension;
import hudson.plugins.selenium.configuration.browser.selenium.SeleniumBrowser;
import hudson.util.FormValidation;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public class ChromeBrowser
extends SeleniumBrowser {
    private static final long serialVersionUID = 2L;
    private final transient String chromeDriverProperty = "webdriver.chrome.driver";
    private String driverBinaryPath;
    @Deprecated
    private transient String server_binary;

    @DataBoundConstructor
    public ChromeBrowser(int maxInstances, String version, String driverBinaryPath) {
        super(maxInstances, version, "*googlechrome");
        this.driverBinaryPath = driverBinaryPath;
    }

    @Exported
    public String getDriverBinaryPath() {
        return this.driverBinaryPath;
    }

    @Override
    public Map<String, String> getJVMArgs() {
        HashMap<String, String> args = new HashMap<String, String>();
        ChromeBrowser.combine(args, "webdriver.chrome.driver", this.getDriverBinaryPath());
        return args;
    }

    @Deprecated
    public String getServer_binary() {
        return this.server_binary;
    }

    public Object readResolve() {
        if (this.server_binary != null) {
            this.driverBinaryPath = this.server_binary;
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends SeleniumBrowser.SeleniumBrowserDescriptor {
        @Override
        public int getMaxInstances() {
            return 5;
        }

        public String getDisplayName() {
            return "Chrome";
        }

        public FormValidation doCheckDriverBinaryPath(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)"Must not be empty unless it is already defined from a previous chrome browser definition or already defined in the path");
            }
            return FormValidation.ok();
        }
    }
}

