/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration.browser;

import hudson.model.Computer;
import hudson.plugins.selenium.configuration.browser.IeDriverServerUtils;
import hudson.plugins.selenium.configuration.browser.NodeUtils;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class EdgeDriverServerUtils {
    private static final String EDGE_DRIVER_NAME = "MicrosoftWebDriver.exe";

    private EdgeDriverServerUtils() {
    }

    public static String uploadEdgeDriverIfNecessary(Computer computer, String serverBinary) {
        if (StringUtils.isBlank((CharSequence)serverBinary)) {
            String serverPath;
            NodeUtils.OsType nodeOs = NodeUtils.getNodeOS(computer);
            switch (nodeOs) {
                case WINDOWS_64: 
                case WINDOWS_32: {
                    URL url = IeDriverServerUtils.class.getClassLoader().getResource(EDGE_DRIVER_NAME);
                    serverPath = NodeUtils.uploadFileToNode(computer, url, EDGE_DRIVER_NAME);
                    break;
                }
                default: {
                    return serverBinary;
                }
            }
            return serverPath;
        }
        return serverBinary;
    }
}

