/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.plugins.selenium.configuration.ConfigurationDescriptor;
import hudson.plugins.selenium.configuration.SeleniumNodeConfiguration;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class FileConfiguration
extends SeleniumNodeConfiguration {
    private static final long serialVersionUID = 5068212020001695128L;
    private static final Logger LOGGER = Logger.getLogger(FileConfiguration.class.getName());
    private String configURL;

    @DataBoundConstructor
    public FileConfiguration(String configURL, String display) {
        super(display);
        this.configURL = configURL;
    }

    @Exported
    public String getConfigURL() {
        return this.configURL;
    }

    @Override
    public SeleniumRunOptions initOptions(Computer c) {
        SeleniumRunOptions opt = super.initOptions(c);
        try {
            final String filename = "selenium-temp-config-" + System.currentTimeMillis() + ".json";
            String fullPath = (String)c.getNode().getRootPath().act((FilePath.FileCallable)new MasterToSlaveFileCallable<String>(){
                private static final long serialVersionUID = -288688398601004624L;

                public String invoke(File f, VirtualChannel channel) throws IOException {
                    File conf = new File(f, filename);
                    FilePath urlConf = new FilePath(conf);
                    try {
                        urlConf.copyFrom(new URL(FileConfiguration.this.configURL));
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Failed to retrieve configuration from " + FileConfiguration.this.configURL, e);
                    }
                    return conf.getAbsolutePath();
                }
            });
            opt.addOptionIfSet("-nodeConfig", fullPath);
            return opt;
        }
        catch (Exception e) {
            LOGGER.fine("Cannot download the specified configuration file on the node. " + e.getMessage());
            return null;
        }
    }

    @Override
    public String getIcon() {
        return "/images/24x24/document.png";
    }

    @Extension
    public static class DescriptorImpl
    extends ConfigurationDescriptor {
        public String getDisplayName() {
            return "File configuration";
        }
    }
}

