/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.configuration;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.plugins.selenium.configuration.ConfigurationDescriptor;
import hudson.plugins.selenium.configuration.FileConfiguration;
import hudson.plugins.selenium.configuration.SeleniumNodeConfiguration;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import hudson.remoting.VirtualChannel;
import hudson.util.FormValidation;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public class DirectJsonInputConfiguration
extends SeleniumNodeConfiguration {
    private static final Logger LOGGER = Logger.getLogger(FileConfiguration.class.getName());
    private static final long serialVersionUID = 4521592447812296365L;
    private String config;
    private String jvmArgs;
    private String seleniumArgs;

    @DataBoundConstructor
    public DirectJsonInputConfiguration(String display, String config, String jvmArgs, String seleniumArgs) {
        super(display);
        this.config = config.startsWith("\"") ? config.substring(1, config.length() - 1) : config;
        this.jvmArgs = jvmArgs;
        this.seleniumArgs = seleniumArgs;
    }

    @Exported
    public String getConfig() {
        return this.config;
    }

    @Exported
    public String getJvmArgs() {
        return this.jvmArgs;
    }

    @Exported
    public String getSeleniumArgs() {
        return this.seleniumArgs;
    }

    @Override
    public SeleniumRunOptions initOptions(Computer computer) {
        SeleniumRunOptions opt = super.initOptions(computer);
        try {
            final String filename = "selenium-temp-config-" + System.currentTimeMillis() + ".json";
            if (this.jvmArgs != null) {
                Properties p = new Properties();
                p.load(new StringReader(this.jvmArgs.replace("\\", "\\\\")));
                for (Map.Entry<Object, Object> e : p.entrySet()) {
                    opt.getJVMArguments().put(e.getKey().toString(), e.getValue().toString());
                }
            }
            if (this.seleniumArgs != null) {
                for (Object l : IOUtils.readLines((Reader)new StringReader(this.seleniumArgs))) {
                    String line = (String)l;
                    if ((line = line.trim()).contains(" ")) {
                        String[] keyValue = StringUtils.split((String)line, (String)" ", (int)2);
                        opt.addOptionIfSet(keyValue[0], keyValue[1]);
                        continue;
                    }
                    opt.addOption(line);
                }
            }
            String fullPath = (String)computer.getNode().getRootPath().act((FilePath.FileCallable)new MasterToSlaveFileCallable<String>(){
                private static final long serialVersionUID = -288688398601004624L;

                public String invoke(File f, VirtualChannel channel) throws IOException {
                    File conf = new File(f, filename);
                    FilePath urlConf = new FilePath(conf);
                    try {
                        urlConf.copyFrom((InputStream)new ByteArrayInputStream(DirectJsonInputConfiguration.this.config.getBytes()));
                    }
                    catch (InterruptedException e) {
                        throw new IOException("Failed to write configuration to " + filename, e);
                    }
                    return conf.getAbsolutePath();
                }
            });
            opt.addOptionIfSet("-nodeConfig", fullPath);
            return opt;
        }
        catch (Exception e) {
            LOGGER.fine("Cannot write the specified configuration on the node. " + e.getMessage());
            return null;
        }
    }

    @Override
    public String getIcon() {
        return "/images/24x24/document.png";
    }

    @Extension
    public static class DescriptorImpl
    extends ConfigurationDescriptor {
        public String getDisplayName() {
            return "JSON configuration";
        }

        public FormValidation doCheckConfig(@QueryParameter(value="config") String config) {
            FormValidation notEmpty = FormValidation.validateRequired((String)config);
            if (!notEmpty.equals(FormValidation.ok())) {
                return notEmpty;
            }
            try {
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)"Invalid JSON input.");
            }
        }
    }
}

