/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.selenium.actions;

import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.selenium.PluginImpl;
import hudson.plugins.selenium.callables.GetConfigurations;
import hudson.plugins.selenium.configuration.global.SeleniumGlobalConfiguration;
import hudson.plugins.selenium.process.SeleniumRunOptions;
import hudson.remoting.Callable;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;

public class ServiceManagementAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(ServiceManagementAction.class.getName());
    private Computer computer;

    public ServiceManagementAction(Computer c) {
        this.computer = c;
    }

    public String getIconFileName() {
        return "/plugin/selenium/24x24/selenium.png";
    }

    public String getDisplayName() {
        return "Selenium node Management";
    }

    public String getUrlName() {
        return "selenium";
    }

    public HttpResponse doRestart(@QueryParameter String conf) throws IOException, ServletException {
        PluginImpl.getPlugin().validateAdmin();
        this.doStop(conf);
        this.doStart(conf);
        return HttpResponses.forwardToPreviousPage();
    }

    public HttpResponse doStop(@QueryParameter String conf) {
        PluginImpl.getPlugin().validateAdmin();
        PluginImpl.getPlugin().getConfiguration(conf).stop(this.computer);
        return HttpResponses.forwardToPreviousPage();
    }

    public HttpResponse doStart(@QueryParameter String conf) {
        PluginImpl.getPlugin().validateAdmin();
        try {
            PluginImpl.startSeleniumNode(this.computer, (TaskListener)new StreamTaskListener((Writer)new OutputStreamWriter(System.out)), conf);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return HttpResponses.forwardToPreviousPage();
    }

    public Computer getComputer() {
        return this.computer;
    }

    public Map<String, SeleniumRunOptions> getConfigurations() {
        PluginImpl.getPlugin().validateAdmin();
        try {
            return (Map)this.computer.getNode().getRootPath().getChannel().call((Callable)new GetConfigurations());
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    public List<SeleniumGlobalConfiguration> getMatchingConfigurations() {
        PluginImpl.getPlugin().validateAdmin();
        return PluginImpl.getPlugin().getGlobalConfigurationForComputer(this.computer);
    }
}

