/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.markup.MarkupFormatter;
import hudson.markup.RawHtmlMarkupFormatter;
import hudson.model.Computer;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.ManagementLink;
import hudson.model.RootAction;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScriptlerPermissions;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.git.GitScriptlerRepository;
import org.jenkinsci.plugins.scriptler.share.CatalogInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfoCatalog;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;
import org.jenkinsci.plugins.scriptler.util.UIHelper;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class ScriptlerManagement
extends ManagementLink
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(ScriptlerManagement.class.getName());
    private static final String MASTER = "(master)";
    private static final String ALL = "(all)";
    private static final String ALL_SLAVES = "(all slaves)";
    private static final MarkupFormatter INSTANCE = RawHtmlMarkupFormatter.INSTANCE;

    public Permission getScriptlerRunScripts() {
        return ScriptlerPermissions.RUN_SCRIPTS;
    }

    public Permission getScriptlerConfigure() {
        return ScriptlerPermissions.CONFIGURE;
    }

    public boolean hasAtLeastOneScriptlerPermission() {
        return Jenkins.get().hasPermission(ScriptlerPermissions.RUN_SCRIPTS) || Jenkins.get().hasPermission(ScriptlerPermissions.CONFIGURE);
    }

    public void checkAtLeastOneScriptlerPermission() {
        if (!Jenkins.get().hasPermission(ScriptlerPermissions.RUN_SCRIPTS)) {
            Jenkins.get().checkPermission(ScriptlerPermissions.CONFIGURE);
        }
    }

    public String getIconFileName() {
        return this.hasAtLeastOneScriptlerPermission() ? "symbol-file-tray-stacked-outline plugin-ionicons-api" : null;
    }

    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }

    public String getUrlName() {
        return "scriptler";
    }

    public boolean disableRemoteCatalog() {
        return this.getConfiguration().isDisbableRemoteCatalog();
    }

    public String getDisplayName() {
        return Messages.display_name();
    }

    public String getDescription() {
        return Messages.description();
    }

    public ScriptlerManagement getScriptler() {
        return this;
    }

    public ScriptlerConfiguration getConfiguration() {
        return ScriptlerConfiguration.getConfiguration();
    }

    public MarkupFormatter getMarkupFormatter() {
        return INSTANCE;
    }

    @RequirePOST
    public HttpResponse doScriptlerSettings(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="disableRemoteCatalog") boolean disableRemoteCatalog) throws IOException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.setDisbableRemoteCatalog(disableRemoteCatalog);
        cfg.save();
        return new HttpRedirect("settings");
    }

    @RequirePOST
    public HttpResponse doDownloadScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id, @QueryParameter(value="catalog") String catalogName) throws IOException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        ScriptlerConfiguration c = this.getConfiguration();
        if (c.isDisbableRemoteCatalog()) {
            return new HttpRedirect("index");
        }
        for (ScriptInfoCatalog<ScriptInfo> scriptInfoCatalog : this.getCatalogs()) {
            if (!catalogName.equals(scriptInfoCatalog.getInfo().name)) continue;
            ScriptInfo info = scriptInfoCatalog.getEntryById(id);
            String source = scriptInfoCatalog.getScriptSource(scriptInfoCatalog.getEntryById(id));
            ArrayList<Parameter> paramList = new ArrayList<Parameter>();
            for (String paramName : info.getParameters()) {
                paramList.add(new Parameter(paramName, null));
            }
            String finalName = this.saveScriptAndForward(id, info.getName(), info.getComment(), source, false, false, catalogName, id, paramList);
            return new HttpRedirect("editScript?id=" + finalName);
        }
        ForwardToView view = new ForwardToView((Object)this, "catalog.jelly");
        view.with("message", (Object)Messages.download_failed(id, catalogName));
        view.with("catName", (Object)catalogName);
        return view;
    }

    @RequirePOST
    public HttpResponse doScriptAdd(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id, @QueryParameter(value="name") String name, @QueryParameter(value="comment") String comment, @QueryParameter(value="script") String script, @QueryParameter(value="nonAdministerUsing") boolean nonAdministerUsing, @QueryParameter(value="onlyMaster") boolean onlyMaster, String originCatalogName, String originId) throws IOException, ServletException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        List<Parameter> parameters = UIHelper.extractParameters(req.getSubmittedForm());
        this.saveScriptAndForward(id, name, comment, script, nonAdministerUsing, onlyMaster, originCatalogName, originId, parameters);
        return new HttpRedirect("index");
    }

    private String saveScriptAndForward(String id, String name, String comment, String script, boolean nonAdministerUsing, boolean onlyMaster, String originCatalogName, String originId, @NonNull List<Parameter> parameters) throws IOException {
        String string = script = script == null ? "TODO" : script;
        if (StringUtils.isEmpty((String)id)) {
            throw new IllegalArgumentException("'id' must not be empty!");
        }
        String displayName = name == null ? id : name;
        String finalFileName = this.fixFileName(originCatalogName, id);
        File newScriptFile = new File(ScriptlerManagement.getScriptDirectory(), finalFileName);
        if (!Util.isDescendant((File)ScriptlerManagement.getScriptDirectory(), (File)newScriptFile)) {
            LOGGER.log(Level.WARNING, "Folder traversal detected, file path received: {0}, after fixing: {1}", new Object[]{id, finalFileName});
            throw new IOException("Invalid file path received: " + id);
        }
        ScriptHelper.writeScriptToFile(newScriptFile, script);
        this.commitFileToGitRepo(finalFileName);
        ScriptHelper.putScriptInApprovalQueueIfRequired(script);
        Script newScript = null;
        newScript = !StringUtils.isEmpty((String)originId) ? new Script(finalFileName, displayName, comment, true, originCatalogName, originId, new SimpleDateFormat("dd MMM yyyy HH:mm:ss a").format(new Date()), parameters) : new Script(finalFileName, displayName, comment, nonAdministerUsing, parameters, onlyMaster);
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.addOrReplace(newScript);
        cfg.save();
        return finalFileName;
    }

    private void commitFileToGitRepo(String finalFileName) {
        this.getGitRepo().addSingleFileToRepo(finalFileName);
    }

    private GitScriptlerRepository getGitRepo() {
        return (GitScriptlerRepository)((Object)ExtensionList.lookupSingleton(GitScriptlerRepository.class));
    }

    @RequirePOST
    public HttpResponse doHardResetGit() throws IOException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        this.getGitRepo().hardReset();
        return new HttpRedirect("../scriptler.git");
    }

    @RequirePOST
    public HttpResponse doRemoveScript(StaplerRequest res, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        File scriptDirectory = ScriptlerManagement.getScriptDirectory();
        File oldScript = new File(scriptDirectory, id);
        if (!Util.isDescendant((File)scriptDirectory, (File)oldScript)) {
            LOGGER.log(Level.WARNING, "Folder traversal detected, file path received: {0}, after fixing: {1}", new Object[]{id, oldScript});
            throw new Failure("Invalid file path received: " + id);
        }
        if (!oldScript.delete() && oldScript.exists()) {
            throw new Failure("not able to delete " + oldScript.getAbsolutePath());
        }
        try {
            GitScriptlerRepository gitRepo = (GitScriptlerRepository)((Object)ExtensionList.lookupSingleton(GitScriptlerRepository.class));
            gitRepo.rmSingleFileToRepo(id);
        }
        catch (IllegalStateException e) {
            throw new IOException("failed to update git repo", e);
        }
        ScriptlerConfiguration cfg = this.getConfiguration();
        cfg.removeScript(id);
        cfg.save();
        return new HttpRedirect("index");
    }

    @RequirePOST
    public HttpResponse doUploadScript(StaplerRequest req) throws IOException, ServletException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        try {
            FileItem fileItem = req.getFileItem("file");
            boolean nonAdministerUsing = req.getSubmittedForm().getBoolean("nonAdministerUsing");
            String fileName = Util.getFileName((String)fileItem.getName());
            if (StringUtils.isEmpty((String)fileName)) {
                return new HttpRedirect(".");
            }
            this.saveScript(fileItem, nonAdministerUsing, fileName);
            return new HttpRedirect("index");
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    void saveScript(FileItem fileItem, boolean nonAdministerUsing, String fileName) throws Exception {
        String fixedFileName = this.fixFileName(null, fileName);
        File fixedFile = new File(fixedFileName);
        if (fixedFile.isAbsolute()) {
            LOGGER.log(Level.WARNING, "Folder traversal detected, file path received: {0}, after fixing: {1}. Seems to be an attempt to use absolute path instead of relative one", new Object[]{fileName, fixedFileName});
            throw new IOException("Invalid file path received: " + fileName);
        }
        File rootDir = ScriptlerManagement.getScriptDirectory();
        File f = new File(rootDir, fixedFileName);
        if (!Util.isDescendant((File)rootDir, (File)new File(rootDir, fixedFileName))) {
            LOGGER.log(Level.WARNING, "Folder traversal detected, file path received: {0}, after fixing: {1}. Seems to be an attempt to use folder escape.", new Object[]{fileName, fixedFileName});
            throw new IOException("Invalid file path received: " + fileName);
        }
        fileItem.write(f);
        this.commitFileToGitRepo(fixedFileName);
        Script script = ScriptHelper.getScript(fixedFileName, false);
        if (script == null) {
            script = new Script(fixedFileName, fixedFileName, true, nonAdministerUsing, false);
        }
        String scriptSource = ScriptHelper.readScriptFromFile(f);
        ScriptHelper.putScriptInApprovalQueueIfRequired(scriptSource);
        ScriptlerConfiguration config = this.getConfiguration();
        config.addOrReplace(script);
    }

    public void doRunScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException, ServletException {
        this.checkPermission(ScriptlerPermissions.RUN_SCRIPTS);
        Script script = ScriptHelper.getScript(id, true);
        if (script == null) {
            throw new IOException(Messages.scriptNotFound(id));
        }
        if (script.script == null) {
            req.setAttribute("scriptNotFound", (Object)true);
        } else {
            boolean canByPassScriptApproval = Jenkins.get().hasPermission(Jenkins.RUN_SCRIPTS);
            if (!ScriptHelper.isApproved(script.script, false)) {
                req.setAttribute("notApprovedYet", (Object)true);
            }
            req.setAttribute("canByPassScriptApproval", (Object)canByPassScriptApproval);
        }
        req.setAttribute("script", (Object)script);
        req.setAttribute("currentNode", (Object)MASTER);
        req.getView((Object)this, "runScript.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @RequirePOST
    public void doTriggerScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id, @QueryParameter(value="script") String scriptSrc, @QueryParameter(value="node") String node) throws IOException, ServletException {
        String output;
        this.checkPermission(ScriptlerPermissions.RUN_SCRIPTS);
        List<Parameter> parameters = UIHelper.extractParameters(req.getSubmittedForm());
        boolean canByPassScriptApproval = Jenkins.get().hasPermission(Jenkins.RUN_SCRIPTS);
        Script originalScript = ScriptHelper.getScript(id, true);
        if (originalScript == null) {
            rsp.sendError(404, "No script found for id=" + id);
            return;
        }
        String originalScriptSourceCode = originalScript.script;
        Script tempScript = originalScript.copy();
        if (originalScriptSourceCode != null && originalScriptSourceCode.equals(scriptSrc)) {
            tempScript.setScript(originalScriptSourceCode);
        } else {
            tempScript.setScript(scriptSrc);
            ScriptHelper.putScriptInApprovalQueueIfRequired(scriptSrc);
        }
        if (ScriptHelper.isApproved(scriptSrc)) {
            String[] slaves = this.resolveSlaveNames(node);
            output = ScriptHelper.runScript(slaves, scriptSrc, parameters);
        } else {
            LOGGER.log(Level.WARNING, "Script {0} was not approved yet, consider asking your administrator to approve it.", id);
            output = null;
            req.setAttribute("notApprovedYet", (Object)true);
        }
        tempScript.setParameters(parameters);
        req.setAttribute("script", (Object)tempScript);
        req.setAttribute("currentNode", (Object)node);
        req.setAttribute("output", (Object)output);
        req.setAttribute("canByPassScriptApproval", (Object)canByPassScriptApproval);
        req.getView((Object)this, "runScript.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @RequirePOST
    public void doRun(StaplerRequest req, StaplerResponse rsp, @QueryParameter(fixEmpty=true) String script, @QueryParameter(fixEmpty=true) String node, @QueryParameter(fixEmpty=true) String contentType) throws IOException, ServletException {
        this.checkPermission(ScriptlerPermissions.RUN_SCRIPTS);
        String id = req.getRestOfPath();
        if (id.startsWith("/")) {
            id = id.substring(1);
        }
        if (StringUtils.isEmpty((String)id)) {
            throw new RuntimeException("Please specify a script id. Use /scriptler/run/<yourScriptId>");
        }
        Script tempScript = ScriptHelper.getScript(id, true);
        if (tempScript == null) {
            throw new RuntimeException("Unknown script: " + id + ". Use /scriptler/run/<yourScriptId>");
        }
        if (script == null) {
            script = tempScript.script;
        }
        if (!ScriptHelper.isApproved(script)) {
            LOGGER.log(Level.WARNING, "Script {0} was not approved yet, consider asking your administrator to approve it.", id);
            rsp.sendError(403, "Script not approved yet, consider asking your administrator to approve it.");
            return;
        }
        Collection<Parameter> paramArray = this.prepareParameters(req, tempScript);
        rsp.setContentType(contentType == null ? "text/plain" : contentType);
        String[] slaves = this.resolveSlaveNames(node == null ? MASTER : node);
        if (slaves.length > 1) {
            rsp.getOutputStream().print(ScriptHelper.runScript(slaves, script, paramArray));
        } else {
            rsp.getOutputStream().print(ScriptHelper.runScript(slaves[0], script, paramArray));
        }
    }

    @NonNull
    private Collection<Parameter> prepareParameters(StaplerRequest req, Script tempScript) {
        HashMap<String, Parameter> params = new HashMap<String, Parameter>();
        for (Parameter parameter : tempScript.getParameters()) {
            params.put(parameter.getName(), parameter);
        }
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            if (!params.containsKey(entry.getKey())) continue;
            params.put((String)entry.getKey(), new Parameter((String)entry.getKey(), ((String[])entry.getValue())[0]));
        }
        return params.values();
    }

    private String[] resolveSlaveNames(String nameAlias) {
        List<String> slaves = null;
        if (nameAlias.equalsIgnoreCase(ALL) || nameAlias.equalsIgnoreCase(ALL_SLAVES)) {
            slaves = this.getSlaveNames();
            if (nameAlias.equalsIgnoreCase(ALL) && !slaves.contains(MASTER)) {
                slaves.add(MASTER);
            }
            if (nameAlias.equalsIgnoreCase(ALL_SLAVES)) {
                slaves.remove(MASTER);
            }
        } else {
            slaves = Collections.singletonList(nameAlias);
        }
        return slaves.toArray(new String[0]);
    }

    public void doShowScript(StaplerRequest req, StaplerResponse rsp, @AncestorInPath Item item, @QueryParameter(value="id") String id) throws IOException, ServletException {
        Jenkins jenkins = Jenkins.get();
        if (!jenkins.hasAnyPermission(new Permission[]{ScriptlerPermissions.RUN_SCRIPTS, ScriptlerPermissions.CONFIGURE})) {
            Jenkins parent = item == null ? jenkins : item;
            parent.checkPermission(Item.CONFIGURE);
        }
        Script script = ScriptHelper.getScript(id, true);
        req.setAttribute("script", (Object)script);
        req.getView((Object)this, "show.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public void doEditScript(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="id") String id) throws IOException, ServletException {
        this.checkPermission(ScriptlerPermissions.CONFIGURE);
        Script script = ScriptHelper.getScript(id, true);
        if (script == null || script.script == null) {
            req.setAttribute("scriptNotFound", (Object)true);
        } else {
            boolean canByPassScriptApproval = Jenkins.get().hasPermission(Jenkins.RUN_SCRIPTS);
            if (!ScriptHelper.isApproved(script.script, false)) {
                req.setAttribute("notApprovedYet", (Object)true);
            }
            req.setAttribute("canByPassScriptApproval", (Object)canByPassScriptApproval);
        }
        req.setAttribute("script", (Object)script);
        req.getView((Object)this, "edit.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public List<String> getSlaveAlias(Script script) {
        if (script.onlyMaster) {
            ArrayList<String> slaveNames = new ArrayList<String>();
            slaveNames.add(MASTER);
            return slaveNames;
        }
        List<String> slaveNames = this.getSlaveNames();
        if (!slaveNames.contains(MASTER)) {
            slaveNames.add(0, MASTER);
        }
        if (slaveNames.size() > 0) {
            if (!slaveNames.contains(ALL)) {
                slaveNames.add(1, ALL);
            }
            if (!slaveNames.contains(ALL_SLAVES)) {
                slaveNames.add(2, ALL_SLAVES);
            }
        }
        return slaveNames;
    }

    private List<String> getSlaveNames() {
        Computer[] computers = Jenkins.get().getComputers();
        ArrayList<String> slaves = new ArrayList<String>();
        for (Computer c : computers) {
            slaves.add(c.getName());
        }
        return slaves;
    }

    public List<? extends ScriptInfoCatalog<ScriptInfo>> getCatalogs() {
        return ScriptInfoCatalog.all();
    }

    public ScriptInfoCatalog<? extends ScriptInfo> getCatalogByName(String catalogName) {
        if (StringUtils.isNotBlank((String)catalogName)) {
            for (ScriptInfoCatalog<ScriptInfo> scriptInfoCatalog : this.getCatalogs()) {
                CatalogInfo info = scriptInfoCatalog.getInfo();
                if (!catalogName.equals(info.name)) continue;
                return scriptInfoCatalog;
            }
        }
        return null;
    }

    public CatalogInfo getCatalogInfoByName(String catalogName) {
        if (StringUtils.isNotBlank((String)catalogName)) {
            for (ScriptInfoCatalog<ScriptInfo> scriptInfoCatalog : this.getCatalogs()) {
                CatalogInfo info = scriptInfoCatalog.getInfo();
                if (!catalogName.equals(info.name)) continue;
                return info;
            }
        }
        return null;
    }

    public static File getScriptDirectory() {
        return new File(ScriptlerManagement.getScriptlerHomeDirectory(), "scripts");
    }

    public static File getScriptlerHomeDirectory() {
        return new File(Jenkins.get().getRootDir(), "scriptler");
    }

    private void checkPermission(Permission permission) {
        Jenkins.get().checkPermission(permission);
    }

    private String fixFileName(String catalogName, String name) {
        if (!((String)name).endsWith(".groovy")) {
            if (!StringUtils.isEmpty((String)catalogName)) {
                name = (String)name + "." + catalogName;
            }
            name = (String)name + ".groovy";
        }
        name = ((String)name).replace(" ", "_").trim();
        LOGGER.fine("set file name to: " + (String)name);
        return name;
    }
}

