/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.util.StreamTaskListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScriptlerManagement;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.share.ScriptInfo;
import org.jenkinsci.plugins.scriptler.util.GroovyScript;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedUsageException;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;

public class ScriptHelper {
    private static final Logger LOGGER = Logger.getLogger(ScriptHelper.class.getName());
    private static final Pattern SCRIPT_META_PATTERN = Pattern.compile(".*BEGIN META(.+?)END META.*", 32);
    private static final Map<String, Class<?>> JSON_CLASS_MAPPING = new HashMap();

    @NonNull
    public static String readScriptFromFile(@NonNull File file) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public static void writeScriptToFile(@NonNull File file, @NonNull String script) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)script, (Charset)StandardCharsets.UTF_8);
    }

    @CheckForNull
    public static Script getScript(String id, boolean withSrc) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        Script s = ScriptlerConfiguration.getConfiguration().getScriptById(id);
        if (withSrc && s != null) {
            File scriptSrc = new File(ScriptlerManagement.getScriptDirectory(), s.getScriptPath());
            try {
                s.setScript(ScriptHelper.readScriptFromFile(scriptSrc));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, Messages.scriptSourceNotFound(id));
            }
        }
        return s;
    }

    public static void putScriptInApprovalQueueIfRequired(String scriptSourceCode) {
        ScriptApproval.get().configuring(scriptSourceCode, GroovyLanguage.get(), ApprovalContext.create().withCurrentUser());
    }

    public static boolean isApproved(String scriptSourceCode) {
        return ScriptHelper.isApproved(scriptSourceCode, true);
    }

    public static boolean isApproved(String scriptSourceCode, boolean putInApprovalQueueIfNotApprovedYet) {
        try {
            ScriptApproval.get().using(scriptSourceCode, GroovyLanguage.get());
            return true;
        }
        catch (UnapprovedUsageException e) {
            if (putInApprovalQueueIfNotApprovedYet) {
                ScriptHelper.putScriptInApprovalQueueIfRequired(scriptSourceCode);
                try {
                    ScriptApproval.get().using(scriptSourceCode, GroovyLanguage.get());
                    return true;
                }
                catch (UnapprovedUsageException unapprovedUsageException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public static String runScript(String[] slaves, String scriptTxt, @NonNull Collection<Parameter> parameters) throws IOException, ServletException {
        StringBuffer output = new StringBuffer();
        for (String slave : slaves) {
            LOGGER.log(Level.FINE, "here is the node -> " + slave);
            output.append("___________________________________________\n");
            output.append("[" + slave + "]:\n");
            output.append(ScriptHelper.runScript(slave, scriptTxt, parameters));
        }
        output.append("___________________________________________\n");
        return output.toString();
    }

    public static String runScript(String node, String scriptTxt, @NonNull Collection<Parameter> parameters) throws IOException, ServletException {
        Object output = "[no output]";
        ByteArrayOutputStream sos = new ByteArrayOutputStream();
        if (node != null && scriptTxt != null) {
            try {
                Computer comp = Jenkins.get().getComputer(node);
                output = comp == null && "(master)".equals(node) ? FilePath.localChannel.call((Callable)new GroovyScript(scriptTxt, parameters, false, (TaskListener)new StreamTaskListener((OutputStream)sos, StandardCharsets.UTF_8))) : (comp == null ? Messages.node_not_found(node) + "\n" : (comp.getChannel() == null ? Messages.node_not_online(node) + "\n" : comp.getChannel().call((Callable)new GroovyScript(scriptTxt, parameters, false, (TaskListener)new StreamTaskListener((OutputStream)sos, StandardCharsets.UTF_8)))));
            }
            catch (InterruptedException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return new String(sos.toByteArray(), StandardCharsets.UTF_8);
    }

    public static ScriptInfo extractScriptInfo(String fullScriptBody) {
        Matcher matcher = SCRIPT_META_PATTERN.matcher(fullScriptBody);
        if (matcher.find()) {
            String group = matcher.group(1);
            JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)group.trim());
            return (ScriptInfo)JSONObject.toBean((JSONObject)json, ScriptInfo.class, JSON_CLASS_MAPPING);
        }
        return null;
    }

    static {
        JSON_CLASS_MAPPING.put("authors", ScriptInfo.Author.class);
        JSON_CLASS_MAPPING.put("parameters", Parameter.class);
    }
}

