/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.tokenmacro;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.LocalChannel;
import java.io.IOException;
import java.util.Collections;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.util.GroovyScript;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class ScriptlerTokenMacro
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter
    public String scriptId;

    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        LocalChannel channel;
        Script script = ScriptHelper.getScript(this.scriptId, true);
        if (script == null) {
            throw new MacroEvaluationException(Messages.tokenmacro_ScriptDoesNotExist(this.scriptId));
        }
        if (!script.nonAdministerUsing) {
            listener.getLogger().println(Messages.tokenmacro_AdminScriptOnly(this.scriptId));
            throw new MacroEvaluationException(Messages.tokenmacro_AdminScriptOnly(this.scriptId));
        }
        if (script.onlyMaster) {
            channel = FilePath.localChannel;
        } else {
            FilePath remoteFilePath = context.getWorkspace();
            if (remoteFilePath == null) {
                throw new ChannelClosedException((Channel)null, null);
            }
            channel = remoteFilePath.getChannel();
        }
        Object output = channel.call((Callable)new GroovyScript(script.script, Collections.emptyList(), true, listener, null, context));
        return output != null ? output.toString() : "";
    }

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals("SCRIPTLER");
    }
}

