/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.builder;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Failure;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.Permission;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormApply;
import hudson.util.QuotedStringTokenizer;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.util.xstream.CriticalXStreamException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScriptlerManagement;
import org.jenkinsci.plugins.scriptler.ScriptlerPermissions;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.util.GroovyScript;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;
import org.jenkinsci.plugins.scriptler.util.UIHelper;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ScriptlerBuilder
extends Builder
implements Serializable {
    private static final AtomicInteger CURRENT_ID = new AtomicInteger();
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ScriptlerBuilder.class.getName());
    private final String builderId;
    private final String scriptId;
    private final boolean propagateParams;
    @NonNull
    private final List<Parameter> parameters;

    @Deprecated
    public ScriptlerBuilder(String builderId, String scriptId, boolean propagateParams, Parameter[] parameters) {
        this(builderId, scriptId, propagateParams, Arrays.asList(Objects.requireNonNull(parameters)));
    }

    public ScriptlerBuilder(String builderId, String scriptId, boolean propagateParams, @NonNull List<Parameter> parameters) {
        this.builderId = builderId;
        this.scriptId = scriptId;
        this.parameters = new ArrayList<Parameter>(parameters);
        this.propagateParams = propagateParams;
    }

    @Nonnull
    private Map<String, String> checkGenericData() {
        HashMap<String, String> errors = new HashMap<String, String>();
        Script script = ScriptHelper.getScript(this.scriptId, true);
        if (script != null && !script.nonAdministerUsing) {
            errors.put("scriptId", "The script is not allowed to be executed in a build, check its configuration!");
        }
        this.checkPermission(errors);
        return errors;
    }

    private void checkPermission(@Nonnull Map<String, String> errors) {
        if (Jenkins.get().hasPermission(Jenkins.RUN_SCRIPTS)) {
            return;
        }
        Project<?, ?> project = this.retrieveProjectUsingCurrentRequest();
        if (project != null && !this.hasSameScriptlerBuilderInProject(project, this)) {
            if (StringUtils.isBlank((String)this.builderId)) {
                errors.put("builderId", "As the given builder does not have ID, it must be equals to one of the existing builder that does not have ID");
            } else {
                errors.put("builderId", "The builderId must correspond to an existing builder of that project since the user does not have the rights to add/edit Scriptler step");
            }
        }
    }

    private ScriptlerBuilder recreateBuilderWithBuilderIdIfRequired() {
        if (StringUtils.isBlank((String)this.builderId)) {
            return new ScriptlerBuilder(ScriptlerBuilder.generateBuilderId(), this.scriptId, this.propagateParams, this.parameters);
        }
        return this;
    }

    private Object readResolve() {
        return this;
    }

    private boolean hasSameScriptlerBuilderInProject(@Nonnull Project<?, ?> project, @Nonnull ScriptlerBuilder targetBuilder) {
        List<ScriptlerBuilder> allScriptlerBuilders = this._getAllScriptlerBuildersFromProject(project);
        for (ScriptlerBuilder builder : allScriptlerBuilders) {
            if (!targetBuilder.equals(builder)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private List<ScriptlerBuilder> _getAllScriptlerBuildersFromProject(@Nonnull Project<?, ?> project) {
        return project.getBuildersList().getAll(ScriptlerBuilder.class);
    }

    @CheckForNull
    private Project<?, ?> retrieveProjectUsingCurrentRequest() {
        Project project;
        StaplerRequest currentRequest = Stapler.getCurrentRequest();
        if (currentRequest != null && (project = (Project)Stapler.getCurrentRequest().findAncestorObject(Project.class)) != null) {
            return project;
        }
        return null;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    @Deprecated
    public Parameter[] getParameters() {
        return this.parameters.toArray(new Parameter[0]);
    }

    @NonNull
    public List<Parameter> getParametersList() {
        return Collections.unmodifiableList(this.parameters);
    }

    public String getBuilderId() {
        return this.builderId;
    }

    public boolean isPropagateParams() {
        return this.propagateParams;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        Script script = ScriptHelper.getScript(this.scriptId, true);
        if (script == null) {
            if (StringUtils.isBlank((String)this.scriptId)) {
                LOGGER.log(Level.WARNING, "The script id was blank for the build {0}:{1}", new Object[]{build.getProject().getName(), build.getDisplayName()});
                listener.getLogger().println(Messages.scriptNotDefined());
            } else {
                LOGGER.log(Level.WARNING, "The source corresponding to the scriptId {0} was not found (missing file ?) for the build {1}:{2}", new Object[]{this.scriptId, build.getProject().getName(), build.getDisplayName()});
                listener.getLogger().println(Messages.scriptNotFound(this.scriptId));
            }
            return false;
        }
        boolean isOk = false;
        if (!script.nonAdministerUsing) {
            listener.getLogger().println(Messages.scriptNotUsableInBuildStep(script.getName()));
            LOGGER.log(Level.WARNING, "The script [{0} ({1})] is not allowed to be executed in a build, check its configuration. It concerns the build [{2}:{3}]", new Object[]{script.getName(), script.getId(), build.getProject().getName(), build.getDisplayName()});
            return false;
        }
        if (!ScriptHelper.isApproved(script.script)) {
            listener.getLogger().println(Messages.scriptNotApprovedYet(script.getName()));
            LOGGER.log(Level.WARNING, "The script [{0} ({1})] is not approved yet, consider asking your administrator to approve it. It concerns the build [{2}:{3}]", new Object[]{script.getName(), script.getId(), build.getProject().getName(), build.getDisplayName()});
            return false;
        }
        try {
            Object output;
            LinkedList<Parameter> expandedParams = new LinkedList<Parameter>();
            if (this.propagateParams) {
                ParametersAction paramsAction = (ParametersAction)build.getAction(ParametersAction.class);
                if (paramsAction == null) {
                    listener.getLogger().println(Messages.no_parameters_defined());
                } else {
                    List jobParams = paramsAction.getParameters();
                    for (ParameterValue parameterValue : jobParams) {
                        expandedParams.add(new Parameter(parameterValue.getName(), TokenMacro.expandAll(build, (TaskListener)listener, (String)("${" + parameterValue.getName() + "}"), (boolean)false, null)));
                    }
                }
            }
            for (Parameter parameter : this.parameters) {
                expandedParams.add(new Parameter(parameter.getName(), TokenMacro.expandAll(build, (TaskListener)listener, (String)parameter.getValue())));
            }
            if (script.onlyMaster) {
                output = FilePath.localChannel.call((Callable)new GroovyScript(script.script, expandedParams, true, (TaskListener)listener, launcher, build));
            } else {
                VirtualChannel channel = launcher.getChannel();
                if (channel == null) {
                    output = null;
                    listener.getLogger().println(Messages.scriptExecutionFailed(this.scriptId) + " - " + Messages.agent_no_channel());
                } else {
                    output = channel.call((Callable)new GroovyScript(script.script, expandedParams, true, (TaskListener)listener));
                }
            }
            isOk = !(output instanceof Boolean) || !Boolean.FALSE.equals(output);
        }
        catch (IOException | InterruptedException | MacroEvaluationException e) {
            listener.getLogger().println(Messages.scriptExecutionFailed(this.scriptId) + " - " + e.getMessage());
            e.printStackTrace(listener.getLogger());
        }
        return isOk;
    }

    private static String generateBuilderId() {
        return System.currentTimeMillis() + "_" + CURRENT_ID.addAndGet(1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptlerBuilder that = (ScriptlerBuilder)o;
        return Objects.equals(this.propagateParams, that.propagateParams) && Objects.equals(this.builderId, that.builderId) && Objects.equals(this.scriptId, that.scriptId) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.propagateParams, this.builderId, this.scriptId, this.parameters);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static class MultipleErrorFormValidation
    extends RuntimeException
    implements HttpResponse {
        private Map<String, String> fieldToMessage = new HashMap<String, String>();

        public MultipleErrorFormValidation(Map<String, String> fieldToMessage) {
            this.fieldToMessage = fieldToMessage;
        }

        private String getAggregatedMessage() {
            ArrayList<String> errorMessageList = new ArrayList<String>();
            for (Map.Entry<String, String> error : this.fieldToMessage.entrySet()) {
                errorMessageList.add(this.buildMessageForField(error.getKey(), error.getValue()));
            }
            return StringUtils.join(errorMessageList, (String)", ");
        }

        private String buildMessageForField(String fieldName, String fieldMessage) {
            return fieldName + ": " + fieldMessage;
        }

        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            if (FormApply.isApply((StaplerRequest)req)) {
                StringBuilder scriptBuilder = new StringBuilder();
                for (Map.Entry<String, String> error : this.fieldToMessage.entrySet()) {
                    String errorMessage = this.buildMessageForField(error.getKey(), error.getValue());
                    scriptBuilder.append("notificationBar.show(").append(QuotedStringTokenizer.quote((String)errorMessage)).append(",notificationBar.ERROR)");
                }
                FormApply.applyResponse((String)scriptBuilder.toString()).generateResponse(req, rsp, node);
            } else {
                new Failure(this.getAggregatedMessage()).generateResponse(req, rsp, node);
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return Jenkins.get().hasPermission(ScriptlerPermissions.RUN_SCRIPTS);
        }

        public String getDisplayName() {
            return Messages.builder_name();
        }

        public Permission getRequiredPermission() {
            return ScriptlerPermissions.RUN_SCRIPTS;
        }

        public ScriptlerBuilder newInstance(StaplerRequest req, JSONObject formData) {
            Map errors;
            ScriptlerBuilder builder = null;
            String builderId = formData.optString("builderId");
            String id = formData.optString("scriptlerScriptId");
            if (StringUtils.isNotBlank((String)id)) {
                boolean inPropagateParams = formData.getBoolean("propagateParams");
                List<Parameter> params = UIHelper.extractParameters(formData);
                builder = new ScriptlerBuilder(builderId, id, inPropagateParams, params);
            }
            if (builder != null && !(errors = builder.checkGenericData()).isEmpty()) {
                throw new MultipleErrorFormValidation(errors);
            }
            if (builder == null) {
                builder = new ScriptlerBuilder(builderId, null, false, Collections.emptyList());
            }
            return builder.recreateBuilderWithBuilderIdIfRequired();
        }

        public List<Script> getScripts() {
            Set<Script> scripts = this.getConfig().getScripts();
            ArrayList<Script> scriptsForBuilder = new ArrayList<Script>();
            for (Script script : scripts) {
                if (!script.nonAdministerUsing) continue;
                scriptsForBuilder.add(script);
            }
            scriptsForBuilder.sort(Script.COMPARATOR_BY_NAME);
            return scriptsForBuilder;
        }

        private ScriptlerManagement getScriptler() {
            return (ScriptlerManagement)((Object)ExtensionList.lookupSingleton(ScriptlerManagement.class));
        }

        private ScriptlerConfiguration getConfig() {
            return this.getScriptler().getConfiguration();
        }

        @JavaScriptMethod
        public JSONArray getParameters(String scriptlerScriptId) {
            Script script = this.getConfig().getScriptById(scriptlerScriptId);
            if (script != null) {
                return JSONArray.fromObject(script.getParameters());
            }
            return null;
        }
    }

    public static final class ConverterImpl
    extends XStream2.PassthruConverter<ScriptlerBuilder> {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        protected void callback(ScriptlerBuilder obj, UnmarshallingContext context) {
            Map errors = obj.checkGenericData();
            if (!errors.isEmpty()) {
                ConversionException conversionException = new ConversionException("Validation failed");
                for (Map.Entry error : errors.entrySet()) {
                    conversionException.add((String)error.getKey(), (String)error.getValue());
                }
                throw new CriticalXStreamException((XStreamException)conversionException);
            }
        }
    }
}

