/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler;

import hudson.init.InitMilestone;
import hudson.init.Initializer;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.scriptler.ScriptlerManagement;
import org.jenkinsci.plugins.scriptler.SyncUtil;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;

public final class ScriptlerLoadingTasks {
    private static final Logger LOGGER = Logger.getLogger(ScriptlerLoadingTasks.class.getName());

    private ScriptlerLoadingTasks() {
    }

    @Initializer(after=InitMilestone.PLUGINS_PREPARED)
    public static void synchronizeConfig() throws IOException {
        File scriptDirectory;
        boolean dirsDone;
        LOGGER.info("initialize Scriptler");
        File homeDirectory = ScriptlerManagement.getScriptlerHomeDirectory();
        if (!homeDirectory.exists() && !(dirsDone = homeDirectory.mkdirs())) {
            LOGGER.log(Level.SEVERE, "could not create Scriptler home directory: {0}", homeDirectory);
        }
        if (!(scriptDirectory = ScriptlerManagement.getScriptDirectory()).exists() && !scriptDirectory.mkdirs()) {
            LOGGER.log(Level.SEVERE, "could not create Scriptler scripts directory: {0}", scriptDirectory);
        }
        ScriptlerConfiguration cfg = ScriptlerConfiguration.load();
        SyncUtil.syncDirWithCfg(scriptDirectory, cfg);
        cfg.save();
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void setupExistingScripts() {
        for (Script script : ScriptlerConfiguration.getConfiguration().getScripts()) {
            File scriptFile = new File(ScriptlerManagement.getScriptDirectory(), script.getScriptPath());
            try {
                String scriptSource = ScriptHelper.readScriptFromFile(scriptFile);
                ScriptHelper.putScriptInApprovalQueueIfRequired(scriptSource);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Source file for the script [{0}] was not found", script.getId());
            }
        }
    }
}

