/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.util;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.remoting.DelegatingCallable;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import jenkins.model.Jenkins;
import org.apache.commons.collections.map.LRUMap;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.config.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScript
implements DelegatingCallable<Object, RuntimeException> {
    private static final long serialVersionUID = 1L;
    private final String script;
    private final Parameter[] parameters;
    private final boolean failWithException;
    private final TaskListener listener;
    private final transient AbstractBuild<?, ?> build;
    private final transient Launcher launcher;
    private transient ClassLoader cl;
    private static Map<String, ConcurrentLinkedQueue<Script>> cache = Collections.synchronizedMap(new LRUMap(10));
    private static final Set<String> DEFAULT_VARIABLES = new HashSet<String>();

    public GroovyScript(String script, Parameter[] parameters, boolean failWithException, TaskListener listener, Launcher launcher, AbstractBuild<?, ?> build) {
        this.script = script;
        this.parameters = parameters;
        this.failWithException = failWithException;
        this.listener = listener;
        this.cl = this.getClassLoader();
        this.build = build;
        this.launcher = launcher;
    }

    public GroovyScript(String script, Parameter[] parameters, boolean failWithException, TaskListener listener) {
        this(script, parameters, failWithException, listener, null, null);
    }

    public ClassLoader getClassLoader() {
        return Jenkins.getInstance().getPluginManager().uberClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() throws RuntimeException {
        Object object;
        block17: {
            Script parsedScript;
            ConcurrentLinkedQueue<Object> scriptPool;
            PrintStream logger;
            block15: {
                block16: {
                    if (this.cl == null) {
                        this.cl = Thread.currentThread().getContextClassLoader();
                    }
                    logger = this.listener.getLogger();
                    GroovyShell shell = new GroovyShell(this.cl);
                    if (this.parameters != null) {
                        for (Parameter param : this.parameters) {
                            String paramName = param.getName();
                            if (DEFAULT_VARIABLES.contains(paramName)) {
                                logger.println(Messages.skipParamter(paramName));
                                continue;
                            }
                            shell.setVariable(paramName, (Object)param.getValue());
                        }
                    }
                    shell.setVariable("out", (Object)logger);
                    shell.setVariable("listener", (Object)this.listener);
                    if (this.build != null) {
                        shell.setVariable("build", this.build);
                    }
                    if (this.launcher != null) {
                        shell.setVariable("launcher", (Object)this.launcher);
                    }
                    if ((scriptPool = cache.get(this.script)) == null) {
                        scriptPool = new ConcurrentLinkedQueue();
                        cache.put(this.script, scriptPool);
                        scriptPool = cache.get(this.script);
                    }
                    parsedScript = scriptPool.poll();
                    if (parsedScript == null) {
                        parsedScript = shell.parse(this.script);
                    }
                    parsedScript.setBinding(shell.getContext());
                    Object output = parsedScript.run();
                    if (output == null) break block15;
                    logger.println(Messages.resultPrefix() + " " + output);
                    object = output;
                    if (parsedScript == null) break block16;
                    scriptPool.add(parsedScript);
                }
                return object;
            }
            try {
                object = "";
                if (parsedScript == null) break block17;
                scriptPool.add(parsedScript);
            }
            catch (Throwable t) {
                block18: {
                    try {
                        if (this.failWithException) {
                            throw new ScriptlerExecutionException(t);
                        }
                        t.printStackTrace(logger);
                        object = Boolean.FALSE;
                        if (parsedScript == null) break block18;
                        scriptPool.add(parsedScript);
                    }
                    catch (Throwable throwable) {
                        if (parsedScript != null) {
                            scriptPool.add(parsedScript);
                        }
                        throw throwable;
                    }
                }
                return object;
            }
        }
        return object;
    }

    static {
        DEFAULT_VARIABLES.add("out");
        DEFAULT_VARIABLES.add("build");
        DEFAULT_VARIABLES.add("listener");
        DEFAULT_VARIABLES.add("launcher");
    }

    private static final class ScriptlerExecutionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ScriptlerExecutionException(Throwable cause) {
            super(cause);
        }
    }
}

