/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.git;

import hudson.Extension;
import hudson.model.RootAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jenkinsci.main.modules.sshd.SSHD;
import org.jenkinsci.plugins.gitserver.FileBackedHttpGitRepository;
import org.jenkinsci.plugins.scriptler.ScriptlerManagment;
import org.jenkinsci.plugins.scriptler.SyncUtil;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class GitScriptlerRepository
extends FileBackedHttpGitRepository
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(GitScriptlerRepository.class.getName());
    @Inject
    public SSHD sshd;
    static final String REPOID = "scriptler.git";

    public GitScriptlerRepository() {
        super(ScriptlerManagment.getScriptDirectory());
    }

    public String getDisplayName() {
        return null;
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return REPOID;
    }

    protected void checkPushPermission() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
    }

    protected void updateWorkspace(Repository repo) throws IOException, GitAPIException {
        super.updateWorkspace(repo);
        ScriptlerConfiguration cfg = ((ScriptlerManagment)((Object)Jenkins.getInstance().getExtensionList(ScriptlerManagment.class).get(0))).getConfiguration();
        SyncUtil.syncDirWithCfg(ScriptlerManagment.getScriptDirectory(), cfg);
        cfg.save();
    }

    public void addSingleFileToRepo(String fileName) throws Exception {
        try {
            Git git = new Git(this.openRepository());
            AddCommand cmd = git.add();
            cmd.addFilepattern(fileName);
            cmd.call();
            CommitCommand co = git.commit();
            co.setAuthor("Scriptler/" + Jenkins.getAuthentication().getName(), "noreply@jenkins-ci.org");
            co.setMessage("update script via WebUI: " + fileName);
            co.call();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "failed to add/commit " + fileName + " into Git repository", e);
        }
    }

    public void rmSingleFileToRepo(String fileName) throws Exception {
        try {
            Git git = new Git(this.openRepository());
            RmCommand cmd = git.rm();
            cmd.addFilepattern(fileName);
            cmd.call();
            CommitCommand co = git.commit();
            co.setAuthor("Scriptler/" + Jenkins.getAuthentication().getName(), "noreply@jenkins-ci.org");
            co.setMessage("remove script via WebUI: " + fileName);
            co.call();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "failed to remove " + fileName + " from Git repository", e);
        }
    }

    public String hardReset() throws IOException {
        Repository repo = this.openRepository();
        Git git = new Git(repo);
        if (repo.getRepositoryState().canResetHead()) {
            return git.reset().setMode(ResetCommand.ResetType.HARD).setRef("master").call().getObjectId().name();
        }
        return "";
    }

    public Collection<LogInfo> getLog() throws IOException {
        ArrayList<LogInfo> msgs = new ArrayList<LogInfo>();
        try {
            for (RevCommit c : new Git(this.openRepository()).log().call()) {
                msgs.add(new LogInfo(c.getName(), c.getAuthorIdent().getName(), c.getCommitterIdent().getName(), new Date(c.getCommitTime()), c.getFullMessage()));
            }
        }
        catch (NoHeadException e) {
            throw new IOException("not able to retrieve git log", e);
        }
        return msgs;
    }

    public static class LogInfo {
        public final String name;
        public final String author;
        public final String commiter;
        public final String msg;
        public final Date committime;

        public LogInfo(String name, String author, String commiter, Date committime, String msg) {
            this.name = name;
            this.author = author;
            this.commiter = commiter;
            this.committime = committime;
            this.msg = msg;
        }
    }
}

