/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.util;

import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.remoting.Callable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScriptlerManagment;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.util.GroovyScript;

public class ScriptHelper {
    private static final Logger LOGGER = Logger.getLogger(ScriptHelper.class.getName());

    public static Script getScript(String id, boolean withSrc) {
        if (StringUtils.isBlank((String)id)) {
            return null;
        }
        Script s = ScriptlerConfiguration.getConfiguration().getScriptById(id);
        File scriptSrc = new File(ScriptlerManagment.getScriptDirectory(), id);
        if (withSrc) {
            try {
                FileReader reader = new FileReader(scriptSrc);
                String src = IOUtils.toString((Reader)reader);
                s.setScript(src);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, Messages.scriptSourceNotFound(id), e);
            }
        }
        return s;
    }

    public static String runScript(String[] slaves, String scriptTxt, Parameter[] parameters) throws IOException, ServletException {
        StringBuffer output = new StringBuffer();
        for (String slave : slaves) {
            LOGGER.log(Level.FINE, "here is the node -> " + slave);
            output.append("___________________________________________\n");
            output.append("[" + slave + "]:\n");
            output.append(ScriptHelper.runScript(slave, scriptTxt, parameters));
        }
        output.append("___________________________________________\n");
        return output.toString();
    }

    public static String runScript(String node, String scriptTxt, Parameter[] parameters) throws IOException, ServletException {
        Object output = "[no output]";
        ByteArrayOutputStream sos = new ByteArrayOutputStream();
        if (node != null && scriptTxt != null) {
            try {
                PrintStream ps = new PrintStream(sos);
                Computer comp = Hudson.getInstance().getComputer(node);
                output = comp == null && "(master)".equals(node) ? Jenkins.MasterComputer.localChannel.call((Callable)new GroovyScript(scriptTxt, parameters, false, ps)) : (comp == null ? Messages.node_not_found(node) + "\n" : (comp.getChannel() == null ? Messages.node_not_online(node) + "\n" : comp.getChannel().call((Callable)new GroovyScript(scriptTxt, parameters, false, ps))));
            }
            catch (InterruptedException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return sos.toString();
    }
}

