/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler;

import hudson.Plugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScriptlerManagment;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScritplerPluginImpl
extends Plugin {
    private static final Logger LOGGER = Logger.getLogger(ScritplerPluginImpl.class.getName());

    public void start() throws Exception {
        super.start();
        this.synchronizeConfig();
    }

    private void synchronizeConfig() throws IOException {
        File scriptDirectory;
        LOGGER.info("initialize scriptler");
        if (!ScriptlerManagment.getScriptlerHomeDirectory().exists()) {
            ScriptlerManagment.getScriptlerHomeDirectory().mkdirs();
        }
        if (!(scriptDirectory = ScriptlerManagment.getScriptDirectory()).exists()) {
            scriptDirectory.mkdirs();
        }
        List<File> availablePhysicalScripts = this.getAvailableScripts();
        ScriptlerConfiguration cfg = ScriptlerConfiguration.load();
        if (cfg == null) {
            cfg = new ScriptlerConfiguration(new TreeSet<Script>());
        }
        for (File file : availablePhysicalScripts) {
            if (cfg.getScriptByName(file.getName()) != null) continue;
            cfg.addOrReplace(new Script(file.getName(), Messages.script_loaded_from_directory(), false, null));
        }
        HashSet<Script> unavailableScripts = new HashSet<Script>();
        for (Script s : cfg.getScripts()) {
            if (new File(scriptDirectory, s.name).exists()) continue;
            unavailableScripts.add(new Script(s.name, s.comment, false, false));
        }
        for (Script script : unavailableScripts) {
            cfg.addOrReplace(script);
        }
        cfg.save();
    }

    public List<File> getAvailableScripts() throws IOException {
        File scriptDirectory = ScriptlerManagment.getScriptDirectory();
        LOGGER.log(Level.FINE, "Listing files of {0}", scriptDirectory.getAbsoluteFile());
        File[] scriptFiles = scriptDirectory.listFiles();
        List<File> fileList = scriptFiles == null ? new ArrayList<File>() : Arrays.asList(scriptFiles);
        return fileList;
    }
}

