/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.scripts;

import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.scripts.Messages;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

@Restricted(value={NoExternalUse.class})
public class ScriptApprovalNote
extends ConsoleNote<Object> {
    private static final Logger LOGGER = Logger.getLogger(ScriptApprovalNote.class.getName());
    private final int length;

    public static void print(TaskListener listener, RejectedAccessException x) {
        try {
            String text = ScriptApproval.get().isForceSandbox() ? Messages.ScriptApprovalNoteForceSandBox_message() : Messages.ScriptApprovalNote_message();
            listener.getLogger().println(x.getMessage() + ". " + new ScriptApprovalNote(text.length()).encode() + text);
        }
        catch (IOException x2) {
            LOGGER.log(Level.WARNING, null, x2);
        }
    }

    private ScriptApprovalNote(int length) {
        this.length = length;
    }

    public ConsoleAnnotator<Object> annotate(Object context, MarkupText text, int charPos) {
        if (Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            Object url = ScriptApproval.get().getUrlName();
            StaplerRequest2 req = Stapler.getCurrentRequest2();
            url = req != null ? req.getContextPath() + "/" + (String)url : Jenkins.get().getRootUrl() + (String)url;
            text.addMarkup(charPos, charPos + this.length, "<a href='" + (String)url + "'>", "</a>");
        }
        return null;
    }

    @Symbol(value={"scriptApprovalLink"})
    @Extension
    public static class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
    }
}

