/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.scripts;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Item;
import hudson.model.User;
import hudson.security.ACL;
import jenkins.model.Jenkins;

public final class ApprovalContext {
    @CheckForNull
    private final String user;
    @CheckForNull
    private final String item;
    @CheckForNull
    private final String key;

    private ApprovalContext(@CheckForNull String user, @CheckForNull String item, @CheckForNull String key) {
        this.user = user;
        this.item = item;
        this.key = key;
    }

    public static ApprovalContext create() {
        return new ApprovalContext(null, null, null);
    }

    public ApprovalContext withUser(@CheckForNull String user) {
        return new ApprovalContext(ACL.SYSTEM2.getName().equals(user) ? null : user, this.item, this.key);
    }

    public ApprovalContext withCurrentUser() {
        User u = User.current();
        return this.withUser(u != null ? u.getId() : Jenkins.ANONYMOUS2.getName());
    }

    @CheckForNull
    public String getUser() {
        return this.user;
    }

    public ApprovalContext withItem(@CheckForNull Item item) {
        return item != null ? new ApprovalContext(this.user, item.getFullName(), this.key) : this;
    }

    @CheckForNull
    public Item getItem() {
        return this.item != null ? Jenkins.get().getItemByFullName(this.item) : null;
    }

    public ApprovalContext withKey(@CheckForNull String key) {
        return key != null ? new ApprovalContext(this.user, this.item, key) : this;
    }

    @CheckForNull
    public String getKey() {
        return this.key;
    }

    public ApprovalContext withItemAsKey(@CheckForNull Item item) {
        if (item == null) {
            return this;
        }
        String n = item.getFullName();
        return new ApprovalContext(this.user, n, n);
    }
}

