/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.scripts;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.util.FormValidation;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public final class ClasspathEntry
extends AbstractDescribableImpl<ClasspathEntry>
implements Serializable {
    private static final long serialVersionUID = -2873408550951192200L;
    @NonNull
    private final URL url;
    private transient String oldPath;
    private transient boolean shouldBeApproved;

    @DataBoundConstructor
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Null is the expected value for deserealized instances of this class")
    public ClasspathEntry(@NonNull String path) throws MalformedURLException {
        this.url = ClasspathEntry.pathToURL(path);
    }

    static URL pathToURL(String path) throws MalformedURLException {
        if (path.isEmpty()) {
            throw new MalformedURLException("JENKINS-37599: empty classpath entries not allowed");
        }
        try {
            return new URL(path);
        }
        catch (MalformedURLException x) {
            File f = new File(path);
            if (f.isAbsolute()) {
                return f.toURI().toURL();
            }
            throw new MalformedURLException("Classpath entry \u2018" + path + "\u2019 does not look like either a URL or an absolute file path");
        }
    }

    private static File urlToFile(@NonNull URL url) {
        if (url.getProtocol().equals("file")) {
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    static String urlToPath(URL url) {
        File file = ClasspathEntry.urlToFile(url);
        return file != null ? file.getAbsolutePath() : url.toString();
    }

    static boolean isClassDirectoryURL(@NonNull URL url) {
        File file = ClasspathEntry.urlToFile(url);
        if (file != null && file.isDirectory()) {
            return true;
        }
        String u = url.toExternalForm();
        return u.endsWith("/") && !u.startsWith("jar:");
    }

    public boolean isClassDirectory() {
        return ClasspathEntry.isClassDirectoryURL(this.url);
    }

    @NonNull
    public String getPath() {
        return ClasspathEntry.urlToPath(this.url);
    }

    @NonNull
    public URL getURL() {
        return this.url;
    }

    @CheckForNull
    private URI getURI() {
        try {
            return this.url.toURI();
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public String getOldPath() {
        return this.oldPath;
    }

    @DataBoundSetter
    public void setOldPath(String oldPath) {
        this.oldPath = oldPath;
    }

    public boolean isShouldBeApproved() {
        return this.shouldBeApproved;
    }

    @DataBoundSetter
    public void setShouldBeApproved(boolean shouldBeApproved) {
        this.shouldBeApproved = shouldBeApproved;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isScriptAutoApprovalEnabled() {
        return ScriptApproval.ADMIN_AUTO_APPROVAL_ENABLED;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isEntryApproved() {
        return ScriptApproval.get().isClasspathEntryApproved(this.url);
    }

    public String toString() {
        return this.url.toString();
    }

    @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="Method call has been optimized, but we still need URLs as a fallback")
    public boolean equals(Object obj) {
        if (!(obj instanceof ClasspathEntry)) {
            return false;
        }
        ClasspathEntry cmp = (ClasspathEntry)obj;
        URI uri = this.getURI();
        return uri != null ? uri.equals(cmp.getURI()) : this.url.equals(cmp.url);
    }

    @SuppressFBWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="Method call has been optimized, but we still need URLs as a fallback")
    public int hashCode() {
        URI uri = this.getURI();
        return uri != null ? uri.hashCode() : this.url.hashCode();
    }

    @Initializer(before=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void alias() {
        Items.XSTREAM2.alias("entry", ClasspathEntry.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ClasspathEntry> {
        @NonNull
        public String getDisplayName() {
            return "ClasspathEntry";
        }

        public FormValidation doCheckPath(@QueryParameter String value, @QueryParameter String oldPath, @QueryParameter boolean shouldBeApproved) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.warning((String)"Enter a file path or URL.");
            }
            try {
                ClasspathEntry entry = new ClasspathEntry(value);
                entry.setShouldBeApproved(shouldBeApproved);
                entry.setOldPath(oldPath);
                return ScriptApproval.get().checking(entry);
            }
            catch (MalformedURLException x) {
                return FormValidation.error((Throwable)x, (String)("Could not parse: " + value));
            }
        }
    }
}

