/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;

public final class ClassLoaderWhitelist
extends Whitelist {
    private final ClassLoader scriptLoader;

    public ClassLoaderWhitelist(ClassLoader scriptLoader) {
        this.scriptLoader = scriptLoader;
    }

    private boolean permits(Class<?> declaringClass) {
        return declaringClass.getClassLoader() == this.scriptLoader;
    }

    @Override
    public boolean permitsMethod(@NonNull Method method, @NonNull Object receiver, @NonNull Object[] args) {
        return this.permits(method.getDeclaringClass()) && !ClassLoaderWhitelist.isIllegalSyntheticMethod(method);
    }

    @Override
    public boolean permitsConstructor(@NonNull Constructor<?> constructor, @NonNull Object[] args) {
        return this.permits(constructor.getDeclaringClass()) && !ClassLoaderWhitelist.isIllegalSyntheticConstructor(constructor);
    }

    @Override
    public boolean permitsStaticMethod(@NonNull Method method, @NonNull Object[] args) {
        return this.permits(method.getDeclaringClass()) && !ClassLoaderWhitelist.isIllegalSyntheticMethod(method);
    }

    @Override
    public boolean permitsFieldGet(@NonNull Field field, @NonNull Object receiver) {
        return this.permits(field.getDeclaringClass()) && !ClassLoaderWhitelist.isIllegalSyntheticField(field);
    }

    @Override
    public boolean permitsFieldSet(@NonNull Field field, @NonNull Object receiver, Object value) {
        return this.permits(field.getDeclaringClass()) && !ClassLoaderWhitelist.isIllegalSyntheticField(field);
    }

    @Override
    public boolean permitsStaticFieldGet(@NonNull Field field) {
        return this.permits(field.getDeclaringClass()) && !ClassLoaderWhitelist.isIllegalSyntheticField(field);
    }

    @Override
    public boolean permitsStaticFieldSet(@NonNull Field field, Object value) {
        return this.permits(field.getDeclaringClass()) && !ClassLoaderWhitelist.isIllegalSyntheticField(field);
    }

    private static boolean isIllegalSyntheticField(Field field) {
        if (!field.isSynthetic()) {
            return false;
        }
        Class<?> declaringClass = field.getDeclaringClass();
        Class<?> enclosingClass = declaringClass.getEnclosingClass();
        if (field.getType() == enclosingClass && field.getName().startsWith("this$")) {
            return false;
        }
        return !declaringClass.isEnum() || !Modifier.isStatic(field.getModifiers()) || !field.getName().equals("$VALUES");
    }

    private static boolean isIllegalSyntheticMethod(Method method) {
        if (!method.isSynthetic()) {
            return false;
        }
        return !Modifier.isStatic(method.getModifiers()) || !method.getDeclaringClass().isEnum() || !method.getName().equals("$INIT");
    }

    private static boolean isIllegalSyntheticConstructor(Constructor constructor) {
        if (!constructor.isSynthetic()) {
            return false;
        }
        Class declaringClass = constructor.getDeclaringClass();
        Class<?> enclosingClass = declaringClass.getEnclosingClass();
        return enclosingClass == null || constructor.getParameters().length <= 0 || constructor.getParameterTypes()[0] != enclosingClass;
    }
}

