/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.scripts;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.model.BallColor;
import hudson.model.PageDecorator;
import hudson.model.RootAction;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.FormValidation;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.AclAwareWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.StaticWhitelist;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalListener;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jenkinsci.plugins.scriptsecurity.scripts.Language;
import org.jenkinsci.plugins.scriptsecurity.scripts.Messages;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedClasspathException;
import org.jenkinsci.plugins.scriptsecurity.scripts.UnapprovedUsageException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

@Symbol(value={"scriptApproval"})
@Extension
public class ScriptApproval
extends GlobalConfiguration
implements RootAction {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean ADMIN_AUTO_APPROVAL_ENABLED = SystemProperties.getBoolean((String)(ScriptApproval.class.getName() + ".ADMIN_AUTO_APPROVAL_ENABLED"));
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean ALLOW_ADMIN_APPROVAL_ENABLED = SystemProperties.getBoolean((String)(ScriptApproval.class.getName() + ".ALLOW_ADMIN_APPROVAL_ENABLED"));
    private static final Logger LOG = Logger.getLogger(ScriptApproval.class.getName());
    private static final XStream2 XSTREAM2 = new XStream2();
    static final Hasher DEFAULT_HASHER;
    private transient Thread convertDeprecatedApprovedClasspathEntriesThread = null;
    private final TreeSet<String> approvedScriptHashes = new TreeSet();
    private final TreeSet<String> approvedSignatures = new TreeSet();
    private TreeSet<String> aclApprovedSignatures;
    private TreeSet<ApprovedClasspathEntry> approvedClasspathEntries;
    private final LinkedHashSet<PendingScript> pendingScripts = new LinkedHashSet();
    private final LinkedHashSet<PendingSignature> pendingSignatures = new LinkedHashSet();
    private TreeSet<PendingClasspathEntry> pendingClasspathEntries;
    private static final ThreadLocal<Stack<Consumer<RejectedAccessException>>> callbacks;

    protected XmlFile getConfigFile() {
        return new XmlFile((XStream)XSTREAM2, new File(Jenkins.get().getRootDir(), this.getUrlName() + ".xml"));
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    @NonNull
    public static ScriptApproval get() {
        ScriptApproval instance = (ScriptApproval)((Object)ExtensionList.lookup(RootAction.class).get(ScriptApproval.class));
        if (instance == null) {
            throw new IllegalStateException("maybe need to rebuild plugin?");
        }
        return instance;
    }

    synchronized void addApprovedClasspathEntry(ApprovedClasspathEntry acp) {
        this.approvedClasspathEntries.add(acp);
    }

    public boolean isScriptApproved(@NonNull String script, @NonNull Language language) {
        for (Hasher hasher : Hasher.values()) {
            String hash = hasher.hash(script, language.getName());
            if (!this.isScriptHashApproved(hash)) continue;
            return true;
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    private synchronized ConversionCheckResult checkAndConvertApprovedScript(@NonNull String script, @NonNull Language language) {
        String hash = DEFAULT_HASHER.hash(script, language.getName());
        if (this.approvedScriptHashes.contains(hash)) {
            return new ConversionCheckResult(hash, hash, true, false);
        }
        for (Hasher hasher : Hasher.values()) {
            String oldHash;
            if (hasher == DEFAULT_HASHER || !this.approvedScriptHashes.contains(oldHash = hasher.hash(script, language.getName()))) continue;
            LOG.fine("A script is approved with an old hash algorithm. Converting now, this may cause performance issues until all old hashes has been converted or removed.");
            this.approvedScriptHashes.remove(oldHash);
            this.approvedScriptHashes.add(hash);
            this.save();
            return new ConversionCheckResult(oldHash, hash, true, true);
        }
        return new ConversionCheckResult(hash, hash, false, false);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    private synchronized ConversionCheckResult checkAndConvertApprovedClasspath(@NonNull URL url) throws IOException {
        String hash = DEFAULT_HASHER.hashClasspathEntry(url);
        ApprovedClasspathEntry acp = new ApprovedClasspathEntry(hash, url);
        if (this.approvedClasspathEntries.contains(acp)) {
            return new ConversionCheckResult(hash, hash, true, false);
        }
        for (Hasher hasher : Hasher.values()) {
            String oldHash;
            ApprovedClasspathEntry oacp;
            if (hasher == DEFAULT_HASHER || !this.approvedClasspathEntries.contains(oacp = new ApprovedClasspathEntry(oldHash = hasher.hashClasspathEntry(url), url))) continue;
            LOG.fine("A classpath is approved with an old hash algorithm. Converting now, this may cause performance issues until all old hashes has been converted or removed.");
            this.approvedClasspathEntries.remove(oacp);
            this.approvedClasspathEntries.add(acp);
            this.save();
            return new ConversionCheckResult(oldHash, hash, true, true);
        }
        return new ConversionCheckResult(hash, hash, false, false);
    }

    @CheckForNull
    private PendingClasspathEntry getPendingClasspathEntry(@NonNull String hash) {
        PendingClasspathEntry e = this.pendingClasspathEntries.floor(PendingClasspathEntry.searchKeyFor(hash));
        if (e != null && e.hash.equals(hash)) {
            return e;
        }
        return null;
    }

    void addPendingClasspathEntry(PendingClasspathEntry pcp) {
        this.pendingClasspathEntries.add(pcp);
    }

    @DataBoundConstructor
    public ScriptApproval() {
        this.load();
    }

    public synchronized void load() {
        this.clear();
        super.load();
        boolean changed = false;
        int dcp = 0;
        Iterator<ApprovedClasspathEntry> i = this.approvedClasspathEntries.iterator();
        while (i.hasNext()) {
            ApprovedClasspathEntry entry = i.next();
            if (entry.isClassDirectory()) {
                i.remove();
                changed = true;
            }
            if (DEFAULT_HASHER.pattern().matcher(entry.hash).matches()) continue;
            ++dcp;
        }
        int dsh = this.countDeprecatedApprovedScriptHashes();
        if (dcp > 0 || dsh > 0) {
            LOG.log(Level.WARNING, "There are {0} deprecated approved script hashes and {1} deprecated approved classpath hashes. They will be rehashed upon next use and that may cause performance issues until all of them are converted or removed.", new Object[]{dsh, dcp});
        }
        if (changed) {
            this.save();
        }
        if (Jenkins.get().getInitLevel() == InitMilestone.COMPLETED) {
            try {
                LOG.log(Level.FINE, "Reconfiguring ScriptApproval after loading configuration from disk");
                this.reconfigure();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, e, () -> "Failed to reconfigure ScriptApproval");
            }
        } else {
            LOG.log(Level.FINE, "Skipping reconfiguration of ScriptApproval during Jenkins startup sequence");
        }
    }

    private void clear() {
        this.approvedScriptHashes.clear();
        this.approvedSignatures.clear();
        this.pendingScripts.clear();
        this.pendingSignatures.clear();
        if (this.aclApprovedSignatures == null) {
            this.aclApprovedSignatures = new TreeSet();
        } else {
            this.aclApprovedSignatures.clear();
        }
        if (this.approvedClasspathEntries == null) {
            this.approvedClasspathEntries = new TreeSet();
        } else {
            this.approvedClasspathEntries.clear();
        }
        if (this.pendingClasspathEntries == null) {
            this.pendingClasspathEntries = new TreeSet();
        } else {
            this.pendingClasspathEntries.clear();
        }
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized boolean hasDeprecatedApprovedScriptHashes() {
        return this.countDeprecatedApprovedScriptHashes() > 0;
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized int countDeprecatedApprovedScriptHashes() {
        int dsh = 0;
        for (String hash : this.approvedScriptHashes) {
            if (DEFAULT_HASHER.pattern().matcher(hash).matches()) continue;
            ++dsh;
        }
        return dsh;
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized int countDeprecatedApprovedClasspathHashes() {
        int dcp = 0;
        for (ApprovedClasspathEntry entry : this.approvedClasspathEntries) {
            if (DEFAULT_HASHER.pattern().matcher(entry.getHash()).matches()) continue;
            ++dcp;
        }
        return dcp;
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized boolean hasDeprecatedApprovedClasspathHashes() {
        return this.countDeprecatedApprovedClasspathHashes() > 0;
    }

    synchronized boolean isEmpty() {
        return this.approvedScriptHashes.isEmpty() && this.approvedSignatures.isEmpty() && this.aclApprovedSignatures.isEmpty() && this.approvedClasspathEntries.isEmpty() && this.pendingScripts.isEmpty() && this.pendingSignatures.isEmpty() && this.pendingClasspathEntries.isEmpty();
    }

    public synchronized String configuring(@NonNull String script, @NonNull Language language, @NonNull ApprovalContext context, boolean approveIfAdmin) {
        ConversionCheckResult result = this.checkAndConvertApprovedScript(script, language);
        if (!result.approved) {
            if (!Jenkins.get().isUseSecurity() || ALLOW_ADMIN_APPROVAL_ENABLED && Jenkins.getAuthentication2() != ACL.SYSTEM2 && Jenkins.get().hasPermission(Jenkins.ADMINISTER) && (ADMIN_AUTO_APPROVAL_ENABLED || approveIfAdmin)) {
                this.approvedScriptHashes.add(result.newHash);
                this.removePendingScript(result.newHash);
            } else {
                String key = context.getKey();
                if (key != null) {
                    this.pendingScripts.removeIf(pendingScript -> key.equals(pendingScript.getContext().getKey()));
                }
                this.pendingScripts.add(new PendingScript(script, language, context));
            }
            this.save();
        }
        return script;
    }

    @Deprecated
    public String configuring(@NonNull String script, @NonNull Language language, @NonNull ApprovalContext context) {
        return this.configuring(script, language, context, false);
    }

    public synchronized String using(@NonNull String script, @NonNull Language language) throws UnapprovedUsageException {
        if (script.length() == 0) {
            return script;
        }
        ConversionCheckResult result = this.checkAndConvertApprovedScript(script, language);
        if (!result.approved) {
            throw new UnapprovedUsageException(result.newHash);
        }
        return script;
    }

    synchronized boolean isScriptHashApproved(String hash) {
        return this.approvedScriptHashes.contains(hash);
    }

    public synchronized void configuring(@NonNull ClasspathEntry entry, @NonNull ApprovalContext context) {
        ConversionCheckResult result;
        if (entry.isClassDirectory()) {
            LOG.log(Level.WARNING, "Classpath {0} is a class directory, which are not allowed. Ignored in configuration, use will be rejected", entry.getURL());
            return;
        }
        URL url = entry.getURL();
        try {
            result = this.checkAndConvertApprovedClasspath(url);
        }
        catch (IOException x) {
            LOG.log(Level.WARNING, null, x);
            return;
        }
        if (!result.approved) {
            boolean shouldSave = false;
            PendingClasspathEntry pcp = new PendingClasspathEntry(result.newHash, url, context);
            if (!Jenkins.get().isUseSecurity() || Jenkins.getAuthentication2() != ACL.SYSTEM2 && Jenkins.get().hasPermission(Jenkins.ADMINISTER) && (ADMIN_AUTO_APPROVAL_ENABLED || entry.isShouldBeApproved() || !StringUtils.equals((String)entry.getOldPath(), (String)entry.getPath()))) {
                LOG.log(Level.FINE, "Classpath entry {0} ({1}) is approved as configured with ADMINISTER permission.", new Object[]{url, result.newHash});
                ApprovedClasspathEntry acp = new ApprovedClasspathEntry(result.newHash, url);
                this.pendingClasspathEntries.remove(pcp);
                this.approvedClasspathEntries.add(acp);
                shouldSave = true;
            } else if (this.pendingClasspathEntries.add(pcp)) {
                LOG.log(Level.FINE, "{0} ({1}) is pending", new Object[]{url, result.newHash});
                shouldSave = true;
            }
            if (shouldSave) {
                this.save();
            }
        }
    }

    public synchronized FormValidation checking(@NonNull ClasspathEntry entry) {
        if (entry.isClassDirectory()) {
            return FormValidation.error((String)Messages.ClasspathEntry_path_noDirsAllowed());
        }
        return FormValidation.ok();
    }

    public synchronized void using(@NonNull ClasspathEntry entry) throws IOException, UnapprovedClasspathException {
        URL url = entry.getURL();
        if (entry.isClassDirectory()) {
            LOG.log(Level.WARNING, "Classpath {0} is a class directory, which are not allowed.", url);
            throw new UnapprovedClasspathException("classpath entry %s is a class directory, which are not allowed.", url, "");
        }
        ConversionCheckResult result = this.checkAndConvertApprovedClasspath(url);
        if (!result.approved) {
            ApprovalContext context = ApprovalContext.create();
            if (this.pendingClasspathEntries.add(new PendingClasspathEntry(result.newHash, url, context))) {
                LOG.log(Level.FINE, "{0} ({1}) is pending.", new Object[]{url, result.newHash});
                this.save();
            }
            throw new UnapprovedClasspathException(url, result.newHash);
        }
        LOG.log(Level.FINER, "{0} ({1}) had been approved", new Object[]{url, result.newHash});
    }

    public synchronized FormValidation checking(@NonNull String script, @NonNull Language language, boolean willBeApproved) {
        if (StringUtils.isEmpty((String)script)) {
            return FormValidation.ok();
        }
        ConversionCheckResult result = this.checkAndConvertApprovedScript(script, language);
        if (result.approved) {
            return FormValidation.okWithMarkup((String)"The script is already approved");
        }
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return FormValidation.warningWithMarkup((String)"A Jenkins administrator will need to approve this script before it can be used");
        }
        if (ALLOW_ADMIN_APPROVAL_ENABLED && (willBeApproved || ADMIN_AUTO_APPROVAL_ENABLED) || !Jenkins.get().isUseSecurity()) {
            return FormValidation.okWithMarkup((String)"The script has not yet been approved, but it will be approved on save.");
        }
        String approveScript = "<a class='jenkins-button script-approval-approve-link' data-base-url='" + Jenkins.get().getRootUrl() + ScriptApproval.get().getUrlName() + "' data-hash='" + result.newHash + "'>Approve script</a>";
        return FormValidation.okWithMarkup((String)("The script is not approved and will not be approved on save. Either modify the script to match an already approved script, approve it explicitly on the <a target='blank' href='" + Jenkins.get().getRootUrl() + ScriptApproval.get().getUrlName() + "'>Script Approval Configuration</a> page after save, or approve this version of the script. " + approveScript));
    }

    @Restricted(value={NoExternalUse.class})
    @POST
    public synchronized void doApproveScriptHash(@QueryParameter(required=true) String hash) throws IOException {
        this.approveScript(hash);
    }

    @Deprecated
    public synchronized FormValidation checking(@NonNull String script, @NonNull Language language) {
        return this.checking(script, language, false);
    }

    synchronized boolean isClasspathEntryApproved(URL url) {
        try {
            ConversionCheckResult result = this.checkAndConvertApprovedClasspath(url);
            return result.approved;
        }
        catch (IOException e) {
            return false;
        }
    }

    public synchronized String preapprove(@NonNull String script, @NonNull Language language) {
        this.approvedScriptHashes.add(DEFAULT_HASHER.hash(script, language.getName()));
        return script;
    }

    public synchronized void preapproveAll() {
        for (PendingScript ps : this.pendingScripts) {
            this.approvedScriptHashes.add(ps.getHash());
        }
        this.pendingScripts.clear();
    }

    @Deprecated
    public synchronized RejectedAccessException accessRejected(@NonNull RejectedAccessException x, @NonNull ApprovalContext context) {
        String signature = x.getSignature();
        if (signature != null && this.pendingSignatures.add(new PendingSignature(signature, x.isDangerous(), context))) {
            this.save();
        }
        return x;
    }

    @Restricted(value={NoExternalUse.class})
    public static void maybeRegister(@NonNull RejectedAccessException x) {
        for (Consumer consumer : callbacks.get()) {
            consumer.accept(x);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static void pushRegistrationCallback(Consumer<RejectedAccessException> callback) {
        callbacks.get().push(callback);
    }

    @Restricted(value={NoExternalUse.class})
    public static void popRegistrationCallback() {
        callbacks.get().pop();
    }

    @DataBoundSetter
    public synchronized void setApprovedSignatures(String[] signatures) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.approvedSignatures.clear();
        ArrayList<String> goodSignatures = new ArrayList<String>(signatures.length);
        for (String signature : signatures) {
            try {
                StaticWhitelist.parse(signature);
                goodSignatures.add(signature);
            }
            catch (IOException e) {
                LOG.warning("Ignoring malformed signature: " + signature + " (Occurred exception: " + e + ")");
            }
        }
        this.approvedSignatures.addAll(goodSignatures);
        this.save();
        this.reconfigure();
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized String[] getApprovedSignatures() {
        return this.approvedSignatures.toArray(new String[this.approvedSignatures.size()]);
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized String[] getDangerousApprovedSignatures() {
        ArrayList<String> dangerous = new ArrayList<String>();
        for (String sig : this.approvedSignatures) {
            if (!StaticWhitelist.isBlacklisted(sig)) continue;
            dangerous.add(sig);
        }
        return dangerous.toArray(new String[dangerous.size()]);
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized String[] getAclApprovedSignatures() {
        return this.aclApprovedSignatures.toArray(new String[this.aclApprovedSignatures.size()]);
    }

    @DataBoundSetter
    public synchronized void setApprovedScriptHashes(String[] scriptHashes) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.approvedScriptHashes.clear();
        for (String scriptHash : scriptHashes) {
            if (!StringUtils.isNotEmpty((String)scriptHash)) continue;
            if (DEFAULT_HASHER.pattern().matcher(scriptHash).matches()) {
                this.approvedScriptHashes.add(scriptHash);
                continue;
            }
            boolean allowed = false;
            for (Hasher hasher : Hasher.values()) {
                if (hasher == DEFAULT_HASHER || !hasher.pattern().matcher(scriptHash).matches()) continue;
                allowed = true;
                break;
            }
            if (allowed) {
                LOG.warning(() -> "Adding deprecated script hash that will be converted on next use: " + scriptHash);
                this.approvedScriptHashes.add(scriptHash);
                continue;
            }
            LOG.warning(() -> "Ignoring malformed script hash: " + scriptHash);
        }
        this.save();
        this.reconfigure();
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized String[] getApprovedScriptHashes() {
        return this.approvedScriptHashes.toArray(new String[this.approvedScriptHashes.size()]);
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "scriptApproval";
    }

    @Restricted(value={NoExternalUse.class})
    public Set<PendingScript> getPendingScripts() {
        return this.pendingScripts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public void approveScript(String hash) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        ScriptApproval scriptApproval = this;
        synchronized (scriptApproval) {
            this.approvedScriptHashes.add(hash);
            this.removePendingScript(hash);
            this.save();
        }
        try (ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);){
            for (ApprovalListener listener : ExtensionList.lookup(ApprovalListener.class)) {
                listener.onApproved(hash);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized void denyScript(String hash) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.approvedScriptHashes.remove(hash);
        this.removePendingScript(hash);
        this.save();
    }

    synchronized void removePendingScript(String hash) {
        Iterator it = this.pendingScripts.iterator();
        while (it.hasNext()) {
            if (!((PendingScript)it.next()).getHash().equals(hash)) continue;
            it.remove();
            break;
        }
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized void clearApprovedScripts() throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.approvedScriptHashes.clear();
        this.save();
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized void clearDeprecatedApprovedScripts() throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.approvedScriptHashes.removeIf(s -> !DEFAULT_HASHER.pattern().matcher((CharSequence)s).matches());
        this.save();
    }

    @Restricted(value={NoExternalUse.class})
    public String getSpinnerIconClassName() {
        return BallColor.GREY_ANIME.getIconClassName();
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized void convertDeprecatedApprovedClasspathEntries() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (!this.isConvertingDeprecatedApprovedClasspathEntries()) {
            List entries = this.approvedClasspathEntries.stream().filter(e -> !DEFAULT_HASHER.pattern().matcher(e.getHash()).matches()).collect(Collectors.toList());
            if (!entries.isEmpty()) {
                LOG.log(Level.INFO, "Scheduling conversion of {0} deprecated approved classpathentry hashes.", entries.size());
                this.convertDeprecatedApprovedClasspathEntriesThread = new Thread(() -> {
                    HashMap<String, ApprovedClasspathEntry> result = new HashMap<String, ApprovedClasspathEntry>();
                    for (int i = 0; i < entries.size(); ++i) {
                        ApprovedClasspathEntry entry = (ApprovedClasspathEntry)entries.get(i);
                        URL entryURL = entry.getURL();
                        LOG.log(Level.INFO, String.format("Converting %s\t(%d/%d)", entryURL, i + 1, entries.size()));
                        try {
                            String hash = DEFAULT_HASHER.hashClasspathEntry(entryURL);
                            result.put(entryURL.toExternalForm(), new ApprovedClasspathEntry(hash, entryURL));
                        }
                        catch (Throwable e2) {
                            LOG.log(Level.WARNING, "Failed to convert " + entryURL, e2);
                        }
                        Thread.yield();
                    }
                    ScriptApproval scriptApproval = this;
                    synchronized (scriptApproval) {
                        this.approvedClasspathEntries.removeIf(e -> result.containsKey(e.getURL().toExternalForm()));
                        this.approvedClasspathEntries.addAll(result.values());
                        try {
                            this.save();
                        }
                        catch (Exception e3) {
                            LOG.log(Level.WARNING, "Failed to store conversion result.", e3);
                        }
                    }
                    LOG.info("Conversion done.");
                    scriptApproval = this;
                    synchronized (scriptApproval) {
                        this.convertDeprecatedApprovedClasspathEntriesThread = null;
                    }
                }, "Approved Classpaths rehasher");
                this.convertDeprecatedApprovedClasspathEntriesThread.setDaemon(true);
                this.convertDeprecatedApprovedClasspathEntriesThread.start();
                LOG.fine("Background conversion task scheduled.");
            } else {
                LOG.info("Nothing to convert.");
            }
        } else {
            LOG.fine("Background conversion task already running.");
        }
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized boolean isConvertingDeprecatedApprovedClasspathEntries() {
        return this.convertDeprecatedApprovedClasspathEntriesThread != null && this.convertDeprecatedApprovedClasspathEntriesThread.isAlive();
    }

    @Restricted(value={NoExternalUse.class})
    public Set<PendingSignature> getPendingSignatures() {
        return this.pendingSignatures;
    }

    private String[][] reconfigure() throws IOException {
        ApprovedWhitelist awl = (ApprovedWhitelist)ExtensionList.lookup(Whitelist.class).get(ApprovedWhitelist.class);
        if (awl != null) {
            return awl.reconfigure();
        }
        return new String[][]{new String[0], new String[0], new String[0]};
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized String[][] approveSignature(String signature) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.pendingSignatures.remove(new PendingSignature(signature, false, ApprovalContext.create()));
        this.approvedSignatures.add(signature);
        this.save();
        return this.reconfigure();
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized String[][] aclApproveSignature(String signature) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.pendingSignatures.remove(new PendingSignature(signature, false, ApprovalContext.create()));
        this.aclApprovedSignatures.add(signature);
        this.save();
        return this.reconfigure();
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized void denySignature(String signature) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.pendingSignatures.remove(new PendingSignature(signature, false, ApprovalContext.create()));
        this.save();
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized String[][] clearApprovedSignatures() throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.approvedSignatures.clear();
        this.aclApprovedSignatures.clear();
        this.save();
        return this.reconfigure();
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized String[][] clearDangerousApprovedSignatures() throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Iterator<String> it = this.approvedSignatures.iterator();
        while (it.hasNext()) {
            if (!StaticWhitelist.isBlacklisted(it.next())) continue;
            it.remove();
        }
        it = this.aclApprovedSignatures.iterator();
        while (it.hasNext()) {
            if (!StaticWhitelist.isBlacklisted(it.next())) continue;
            it.remove();
        }
        this.save();
        return this.reconfigure();
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized List<ApprovedClasspathEntry> getApprovedClasspathEntries() {
        ArrayList<ApprovedClasspathEntry> r = new ArrayList<ApprovedClasspathEntry>(this.approvedClasspathEntries);
        r.sort(Comparator.comparing(o -> o.url.toString()));
        return r;
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized List<PendingClasspathEntry> getPendingClasspathEntries() {
        ArrayList<PendingClasspathEntry> r = new ArrayList<PendingClasspathEntry>(this.pendingClasspathEntries);
        r.sort(Comparator.comparing(o -> o.url.toString()));
        return r;
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public JSON getClasspathRenderInfo() {
        JSONArray pendings = new JSONArray();
        for (PendingClasspathEntry cp : this.getPendingClasspathEntries()) {
            pendings.add((Object)new JSONObject().element("hash", (Object)cp.getHash()).element("path", (Object)ClasspathEntry.urlToPath(cp.getURL())));
        }
        JSONArray approveds = new JSONArray();
        for (ApprovedClasspathEntry cp : this.getApprovedClasspathEntries()) {
            approveds.add((Object)new JSONObject().element("hash", (Object)cp.getHash()).element("path", (Object)ClasspathEntry.urlToPath(cp.getURL())));
        }
        return new JSONArray().element((Collection)pendings).element((Collection)approveds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized JSON approveClasspathEntry(String hash) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        URL url = null;
        ScriptApproval scriptApproval = this;
        synchronized (scriptApproval) {
            PendingClasspathEntry cp = this.getPendingClasspathEntry(hash);
            if (cp != null) {
                this.pendingClasspathEntries.remove(cp);
                url = cp.getURL();
                this.approvedClasspathEntries.add(new ApprovedClasspathEntry(hash, url));
                this.save();
            }
        }
        if (url != null) {
            try (ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);){
                for (ApprovalListener listener : ExtensionList.lookup(ApprovalListener.class)) {
                    listener.onApprovedClasspathEntry(hash, url);
                }
            }
        }
        return this.getClasspathRenderInfo();
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized JSON denyClasspathEntry(String hash) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        PendingClasspathEntry cp = this.getPendingClasspathEntry(hash);
        if (cp != null) {
            this.pendingClasspathEntries.remove(cp);
            this.save();
        }
        return this.getClasspathRenderInfo();
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized JSON denyApprovedClasspathEntry(String hash) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (this.approvedClasspathEntries.remove(new ApprovedClasspathEntry(hash, null))) {
            this.save();
        }
        return this.getClasspathRenderInfo();
    }

    @Restricted(value={NoExternalUse.class})
    @JavaScriptMethod
    public synchronized JSON clearApprovedClasspathEntries() throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        this.approvedClasspathEntries.clear();
        this.save();
        return this.getClasspathRenderInfo();
    }

    static {
        XSTREAM2.alias("com.cloudbees.hudson.plugins.modeling.scripts.ScriptApproval", ScriptApproval.class);
        XSTREAM2.alias("com.cloudbees.hudson.plugins.modeling.scripts.ScriptApproval$PendingScript", PendingScript.class);
        XSTREAM2.alias("com.cloudbees.hudson.plugins.modeling.scripts.ScriptApproval$PendingSignature", PendingSignature.class);
        XSTREAM2.alias("scriptApproval", ScriptApproval.class);
        XSTREAM2.alias("approvedClasspathEntry", ApprovedClasspathEntry.class);
        XSTREAM2.alias("pendingScript", PendingScript.class);
        XSTREAM2.alias("pendingSignature", PendingSignature.class);
        XSTREAM2.alias("pendingClasspathEntry", PendingClasspathEntry.class);
        DEFAULT_HASHER = Hasher.SHA512;
        callbacks = ThreadLocal.withInitial(Stack::new);
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class FormValidationPageDecorator
    extends PageDecorator {
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static final class ApprovedWhitelist
    extends ProxyWhitelist {
        public ApprovedWhitelist() {
            super(new Whitelist[0]);
            try {
                this.reconfigure();
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Malformed signature entry in scriptApproval.xml: '" + e.getMessage() + "'");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String[][] reconfigure() throws IOException {
            ScriptApproval instance;
            ScriptApproval scriptApproval = instance = ScriptApproval.get();
            synchronized (scriptApproval) {
                this.reset(Collections.singleton(new AclAwareWhitelist(new StaticWhitelist(instance.approvedSignatures), new StaticWhitelist(instance.aclApprovedSignatures))));
                return new String[][]{instance.getApprovedSignatures(), instance.getAclApprovedSignatures(), instance.getDangerousApprovedSignatures()};
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class PendingClasspathEntry
    extends PendingThing
    implements Comparable<PendingClasspathEntry> {
        private final String hash;
        private final URL url;
        private static final ApprovalContext SEARCH_APPROVAL_CONTEXT = ApprovalContext.create();
        private static URL SEARCH_APPROVAL_URL;

        PendingClasspathEntry(@NonNull String hash, @NonNull URL url, @NonNull ApprovalContext context) {
            super(context);
            this.hash = hash;
            this.url = url;
        }

        @NonNull
        public String getHash() {
            return this.hash;
        }

        @NonNull
        public URL getURL() {
            return this.url;
        }

        public int hashCode() {
            return this.getHash().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof PendingClasspathEntry && ((PendingClasspathEntry)obj).getHash().equals(this.getHash());
        }

        @Override
        public int compareTo(PendingClasspathEntry o) {
            return this.hash.compareTo(o.hash);
        }

        @NonNull
        public static PendingClasspathEntry searchKeyFor(@NonNull String hash) {
            return new PendingClasspathEntry(hash, SEARCH_APPROVAL_URL, SEARCH_APPROVAL_CONTEXT);
        }

        static {
            try {
                SEARCH_APPROVAL_URL = new URL("http://invalid.url/do/not/use");
            }
            catch (Throwable e) {
                LOG.log(Level.WARNING, "Unexpected exception", e);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class PendingSignature
    extends PendingThing {
        public final String signature;
        public final boolean dangerous;

        PendingSignature(@NonNull String signature, boolean dangerous, @NonNull ApprovalContext context) {
            super(context);
            this.signature = signature;
            this.dangerous = dangerous;
        }

        public String getHash() {
            return Integer.toHexString(this.hashCode());
        }

        public int hashCode() {
            return this.signature.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof PendingSignature && ((PendingSignature)obj).signature.equals(this.signature);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class PendingScript
    extends PendingThing {
        public final String script;
        private final String language;

        PendingScript(@NonNull String script, @NonNull Language language, @NonNull ApprovalContext context) {
            super(context);
            this.script = script;
            this.language = language.getName();
        }

        public String getHash() {
            return DEFAULT_HASHER.hash(this.script, this.language);
        }

        public Language getLanguage() {
            for (Language l : ExtensionList.lookup(Language.class)) {
                if (!l.getName().equals(this.language)) continue;
                return l;
            }
            return new Language(){

                @Override
                @NonNull
                public String getName() {
                    return language;
                }

                @Override
                @NonNull
                public String getDisplayName() {
                    return "<missing language: " + language + ">";
                }
            };
        }

        public int hashCode() {
            return this.script.hashCode() ^ this.language.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof PendingScript && ((PendingScript)obj).language.equals(this.language) && ((PendingScript)obj).script.equals(this.script);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static abstract class PendingThing {
        @Deprecated
        private String user;
        @NonNull
        private ApprovalContext context;

        PendingThing(@NonNull ApprovalContext context) {
            this.context = context;
        }

        @NonNull
        public ApprovalContext getContext() {
            return this.context;
        }

        private Object readResolve() {
            if (this.user != null) {
                this.context = ApprovalContext.create().withUser(this.user);
                this.user = null;
            }
            return this;
        }
    }

    static class ConversionCheckResult {
        final String oldHash;
        final String newHash;
        final boolean approved;
        final boolean converted;

        public ConversionCheckResult(String oldHash, String newHash, boolean approved, boolean converted) {
            this.oldHash = oldHash;
            this.newHash = newHash;
            this.approved = approved;
            this.converted = converted;
        }
    }

    static enum Hasher {
        SHA512{
            final Pattern shaPattern = Pattern.compile("SHA512:[a-fA-F0-9]{128}");

            @Override
            String prefix() {
                return "SHA512:";
            }

            @Override
            MessageDigest digest() throws NoSuchAlgorithmException {
                return MessageDigest.getInstance("SHA-512");
            }

            @Override
            Pattern pattern() {
                return this.shaPattern;
            }
        }
        ,
        SHA1{
            final Pattern shaPattern = Pattern.compile("[a-fA-F0-9]{40}");

            @Override
            String prefix() {
                return "";
            }

            @Override
            MessageDigest digest() throws NoSuchAlgorithmException {
                return MessageDigest.getInstance("SHA-1");
            }

            @Override
            Pattern pattern() {
                return this.shaPattern;
            }
        };


        String hash(String script, String language) {
            try {
                MessageDigest digest = this.digest();
                digest.update(language.getBytes(StandardCharsets.UTF_8));
                digest.update((byte)58);
                digest.update(script.getBytes(StandardCharsets.UTF_8));
                return this.prefix() + Util.toHexString((byte[])digest.digest());
            }
            catch (NoSuchAlgorithmException x) {
                throw new AssertionError((Object)x);
            }
        }

        /*
         * Exception decompiling
         */
        String hashClasspathEntry(URL entry) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        abstract String prefix();

        abstract MessageDigest digest() throws NoSuchAlgorithmException;

        abstract Pattern pattern();
    }

    @Restricted(value={NoExternalUse.class})
    public static class ApprovedClasspathEntry
    implements Comparable<ApprovedClasspathEntry> {
        private final String hash;
        private final URL url;

        public ApprovedClasspathEntry(String hash, URL url) {
            this.hash = hash;
            this.url = url;
        }

        public String getHash() {
            return this.hash;
        }

        public URL getURL() {
            return this.url;
        }

        boolean isClassDirectory() {
            return ClasspathEntry.isClassDirectoryURL(this.url);
        }

        public int hashCode() {
            return this.hash.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ApprovedClasspathEntry && ((ApprovedClasspathEntry)obj).hash.equals(this.hash);
        }

        @Override
        public int compareTo(ApprovedClasspathEntry o) {
            return this.hash.compareTo(o.hash);
        }
    }
}

