/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.EnumeratingWhitelist;

public class ProxyWhitelist
extends Whitelist {
    @GuardedBy(value="lock")
    private Collection<? extends Whitelist> originalDelegates;
    @GuardedBy(value="lock")
    final List<Whitelist> delegates = new ArrayList<Whitelist>();
    @GuardedBy(value="lock")
    private final List<EnumeratingWhitelist.MethodSignature> methodSignatures = new ArrayList<EnumeratingWhitelist.MethodSignature>();
    @GuardedBy(value="lock")
    private final List<EnumeratingWhitelist.NewSignature> newSignatures = new ArrayList<EnumeratingWhitelist.NewSignature>();
    @GuardedBy(value="lock")
    private final List<EnumeratingWhitelist.MethodSignature> staticMethodSignatures = new ArrayList<EnumeratingWhitelist.MethodSignature>();
    @GuardedBy(value="lock")
    private final List<EnumeratingWhitelist.FieldSignature> fieldSignatures = new ArrayList<EnumeratingWhitelist.FieldSignature>();
    @GuardedBy(value="lock")
    private final List<EnumeratingWhitelist.FieldSignature> staticFieldSignatures = new ArrayList<EnumeratingWhitelist.FieldSignature>();
    @GuardedBy(value="lock")
    private final Map<ProxyWhitelist, Void> wrappers = new WeakHashMap<ProxyWhitelist, Void>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ProxyWhitelist(Collection<? extends Whitelist> delegates) {
        this.reset(delegates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWrapper(ProxyWhitelist wrapper) {
        assert (wrapper.lock.writeLock().isHeldByCurrentThread());
        this.lock.writeLock().lock();
        try {
            this.wrappers.put(wrapper, null);
            this.lock.readLock().lock();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        try {
            for (Whitelist subdelegate : this.delegates) {
                if (subdelegate instanceof EnumeratingWhitelist) {
                    ((EnumeratingWhitelist)subdelegate).clearCache();
                    continue;
                }
                wrapper.delegates.add(subdelegate);
            }
            wrapper.methodSignatures.addAll(this.methodSignatures);
            wrapper.newSignatures.addAll(this.newSignatures);
            wrapper.staticMethodSignatures.addAll(this.staticMethodSignatures);
            wrapper.fieldSignatures.addAll(this.fieldSignatures);
            wrapper.staticFieldSignatures.addAll(this.staticFieldSignatures);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public final void reset(Collection<? extends Whitelist> delegates) {
        this.lock.writeLock().lock();
        try {
            this.originalDelegates = delegates;
            this.reset();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        this.lock.writeLock().lock();
        try {
            this.delegates.clear();
            this.methodSignatures.clear();
            this.newSignatures.clear();
            this.staticMethodSignatures.clear();
            this.fieldSignatures.clear();
            this.staticFieldSignatures.clear();
            this.delegates.add(new EnumeratingWhitelist(){

                @Override
                protected List<EnumeratingWhitelist.MethodSignature> methodSignatures() {
                    return ProxyWhitelist.this.methodSignatures;
                }

                @Override
                protected List<EnumeratingWhitelist.NewSignature> newSignatures() {
                    return ProxyWhitelist.this.newSignatures;
                }

                @Override
                protected List<EnumeratingWhitelist.MethodSignature> staticMethodSignatures() {
                    return ProxyWhitelist.this.staticMethodSignatures;
                }

                @Override
                protected List<EnumeratingWhitelist.FieldSignature> fieldSignatures() {
                    return ProxyWhitelist.this.fieldSignatures;
                }

                @Override
                protected List<EnumeratingWhitelist.FieldSignature> staticFieldSignatures() {
                    return ProxyWhitelist.this.staticFieldSignatures;
                }
            });
            for (Whitelist whitelist : this.originalDelegates) {
                if (whitelist instanceof EnumeratingWhitelist) {
                    EnumeratingWhitelist ew = (EnumeratingWhitelist)whitelist;
                    this.methodSignatures.addAll(ew.methodSignatures());
                    this.newSignatures.addAll(ew.newSignatures());
                    this.staticMethodSignatures.addAll(ew.staticMethodSignatures());
                    this.fieldSignatures.addAll(ew.fieldSignatures());
                    this.staticFieldSignatures.addAll(ew.staticFieldSignatures());
                    ew.clearCache();
                    continue;
                }
                if (whitelist instanceof ProxyWhitelist) {
                    ProxyWhitelist pw = (ProxyWhitelist)whitelist;
                    pw.addWrapper(this);
                    continue;
                }
                Objects.requireNonNull(whitelist);
                this.delegates.add(whitelist);
            }
            for (ProxyWhitelist proxyWhitelist : this.wrappers.keySet()) {
                proxyWhitelist.reset();
            }
            if (this.wrappers.isEmpty()) {
                EnumeratingWhitelist adapter = (EnumeratingWhitelist)this.delegates.get(0);
                adapter.precache();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public ProxyWhitelist(Whitelist ... delegates) {
        this(Arrays.asList(delegates));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsMethod(@NonNull Method method, @NonNull Object receiver, @NonNull Object[] args) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsMethod(method, receiver, args)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsConstructor(@NonNull Constructor<?> constructor, @NonNull Object[] args) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsConstructor(constructor, args)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsStaticMethod(@NonNull Method method, @NonNull Object[] args) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsStaticMethod(method, args)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsFieldGet(@NonNull Field field, @NonNull Object receiver) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsFieldGet(field, receiver)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsFieldSet(@NonNull Field field, @NonNull Object receiver, Object value) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsFieldSet(field, receiver, value)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsStaticFieldGet(@NonNull Field field) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsStaticFieldGet(field)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsStaticFieldSet(@NonNull Field field, Object value) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsStaticFieldSet(field, value)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = super.toString() + this.delegates;
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

