/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.grape.GrabAnnotationTransformation;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.ExtensionList;
import hudson.model.RootAction;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.ClassLoaderWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.Messages;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.RejectASTTransformsCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SandboxInterceptor;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SandboxResolvingClassLoader;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.StaticWhitelist;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApprovalNote;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

public final class GroovySandbox {
    public static final Logger LOGGER = Logger.getLogger(GroovySandbox.class.getName());
    @CheckForNull
    private Whitelist whitelist;
    @CheckForNull
    private ApprovalContext context;
    @CheckForNull
    private TaskListener listener;

    public GroovySandbox withWhitelist(@CheckForNull Whitelist whitelist) {
        this.whitelist = whitelist;
        return this;
    }

    public GroovySandbox withApprovalContext(@CheckForNull ApprovalContext context) {
        this.context = context;
        return this;
    }

    public GroovySandbox withTaskListener(@CheckForNull TaskListener listener) {
        this.listener = listener;
        return this;
    }

    @NonNull
    private Whitelist whitelist() {
        return this.whitelist != null ? this.whitelist : Whitelist.all();
    }

    public Scope enter() {
        SandboxInterceptor sandbox = new SandboxInterceptor(this.whitelist());
        ApprovalContext _context = this.context != null ? this.context : ApprovalContext.create();
        sandbox.register();
        ScriptApproval.pushRegistrationCallback(x -> {
            if (ExtensionList.lookup(RootAction.class).get(ScriptApproval.class) == null) {
                return;
            }
            String signature = x.getSignature();
            if (!StaticWhitelist.isPermanentlyBlacklisted(signature)) {
                ScriptApproval.get().accessRejected((RejectedAccessException)x, _context);
            }
            if (this.listener != null) {
                ScriptApprovalNote.print(this.listener, x);
            }
        });
        return () -> {
            sandbox.unregister();
            ScriptApproval.popRegistrationCallback();
        };
    }

    public Object runScript(@NonNull GroovyShell shell, @NonNull String script) {
        GroovySandbox derived = new GroovySandbox().withApprovalContext(this.context).withTaskListener(this.listener).withWhitelist(new ProxyWhitelist(new ClassLoaderWhitelist((ClassLoader)shell.getClassLoader()), this.whitelist()));
        try (Scope scope = derived.enter();){
            Object object = shell.parse(script).run();
            return object;
        }
    }

    @NonNull
    public static CompilerConfiguration createSecureCompilerConfiguration() {
        CompilerConfiguration cc = GroovySandbox.createBaseCompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
        return cc;
    }

    @NonNull
    public static CompilerConfiguration createBaseCompilerConfiguration() {
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new RejectASTTransformsCustomizer()});
        cc.setDisabledGlobalASTTransformations(new HashSet<String>(Collections.singletonList(GrabAnnotationTransformation.class.getName())));
        return cc;
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Should be managed by the caller.")
    @NonNull
    public static ClassLoader createSecureClassLoader(ClassLoader base) {
        return new SandboxResolvingClassLoader(base);
    }

    @Deprecated
    public static void runInSandbox(@NonNull Runnable r, @NonNull Whitelist whitelist) throws RejectedAccessException {
        try (Scope scope = new GroovySandbox().withWhitelist(whitelist).enter();){
            r.run();
        }
    }

    @Deprecated
    public static <V> V runInSandbox(@NonNull Callable<V> c, @NonNull Whitelist whitelist) throws Exception {
        try (Scope scope = new GroovySandbox().withWhitelist(whitelist).enter();){
            V v = c.call();
            return v;
        }
    }

    @Deprecated
    public static Object run(@NonNull Script script, @NonNull Whitelist whitelist) throws RejectedAccessException {
        LOGGER.log(Level.WARNING, null, new IllegalStateException(Messages.GroovySandbox_useOfInsecureRunOverload()));
        ProxyWhitelist wrapperWhitelist = new ProxyWhitelist(new ClassLoaderWhitelist(script.getClass().getClassLoader()), whitelist);
        try (Scope scope = new GroovySandbox().withWhitelist(wrapperWhitelist).enter();){
            Object object = script.run();
            return object;
        }
    }

    @Deprecated
    public static Object run(@NonNull GroovyShell shell, @NonNull String script, @NonNull Whitelist whitelist) throws RejectedAccessException {
        return new GroovySandbox().withWhitelist(whitelist).runScript(shell, script);
    }

    @NonNull
    public static FormValidation checkScriptForCompilationErrors(String script, GroovyClassLoader classLoader) {
        try {
            CompilationUnit cu = new CompilationUnit(GroovySandbox.createSecureCompilerConfiguration(), new CodeSource(new URL("file", "", "/groovy/shell"), (Certificate[])null), classLoader);
            cu.addSource("Script1", script);
            cu.compile(5);
        }
        catch (MalformedURLException | CompilationFailedException e) {
            return FormValidation.error((String)e.getLocalizedMessage());
        }
        return FormValidation.ok();
    }

    @FunctionalInterface
    public static interface Scope
    extends AutoCloseable {
        @Override
        public void close();
    }
}

