/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;

public abstract class Whitelist
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(Whitelist.class.getName());
    private static final Map<Jenkins, Whitelist> allByJenkins = new WeakHashMap<Jenkins, Whitelist>();

    public abstract boolean permitsMethod(@Nonnull Method var1, @Nonnull Object var2, @Nonnull Object[] var3);

    public abstract boolean permitsConstructor(@Nonnull Constructor<?> var1, @Nonnull Object[] var2);

    public abstract boolean permitsStaticMethod(@Nonnull Method var1, @Nonnull Object[] var2);

    public abstract boolean permitsFieldGet(@Nonnull Field var1, @Nonnull Object var2);

    public abstract boolean permitsFieldSet(@Nonnull Field var1, @Nonnull Object var2, @CheckForNull Object var3);

    public abstract boolean permitsStaticFieldGet(@Nonnull Field var1);

    public abstract boolean permitsStaticFieldSet(@Nonnull Field var1, @CheckForNull Object var2);

    @Nonnull
    public static synchronized Whitelist all() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null) {
            LOGGER.log(Level.WARNING, "No Jenkins.instance", new Throwable("here"));
            return new ProxyWhitelist(new Whitelist[0]);
        }
        Whitelist all = allByJenkins.get(j);
        if (all == null) {
            ExtensionList allWhitelists = j.getExtensionList(Whitelist.class);
            if (allWhitelists.isEmpty()) {
                LOGGER.log(Level.WARNING, "No Whitelist instances registered", new Throwable("here"));
                return new ProxyWhitelist(new Whitelist[0]);
            }
            LOGGER.fine(() -> "Loading whitelists: " + allWhitelists);
            all = new ProxyWhitelist((Collection<? extends Whitelist>)allWhitelists);
            allByJenkins.put(j, all);
        }
        return all;
    }
}

