/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

class SandboxResolvingClassLoader
extends ClassLoader {
    private static final Logger LOGGER = Logger.getLogger(SandboxResolvingClassLoader.class.getName());
    private static final LoadingCache<ClassLoader, Cache<String, Class<?>>> parentClassCache = SandboxResolvingClassLoader.makeParentCache(true);
    private static final LoadingCache<ClassLoader, Cache<String, Optional<URL>>> parentResourceCache = SandboxResolvingClassLoader.makeParentCache(false);
    private static final Class<?> CLASS_NOT_FOUND = Unused.class;

    SandboxResolvingClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("org.kohsuke.groovy.sandbox.")) {
            return this.getClass().getClassLoader().loadClass(name);
        }
        ClassLoader parentLoader = this.getParent();
        Class c = SandboxResolvingClassLoader.load(parentClassCache, name, parentLoader, () -> {
            try {
                return parentLoader.loadClass(name);
            }
            catch (ClassNotFoundException x) {
                return CLASS_NOT_FOUND;
            }
        });
        if (c != CLASS_NOT_FOUND) {
            if (resolve) {
                super.resolveClass(c);
            }
            return c;
        }
        throw new ClassNotFoundException(name){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
    }

    @Override
    public URL getResource(String name) {
        ClassLoader parentLoader = this.getParent();
        return (URL)SandboxResolvingClassLoader.load(parentResourceCache, name, parentLoader, () -> Optional.fromNullable((Object)parentLoader.getResource(name))).orNull();
    }

    private static <T> T load(LoadingCache<ClassLoader, Cache<String, T>> cache, String name, ClassLoader parentLoader, Supplier<T> supplier) {
        try {
            return (T)((Cache)cache.getUnchecked((Object)parentLoader)).get((Object)name, () -> {
                Object t;
                Thread t2 = Thread.currentThread();
                String origName = t2.getName();
                t2.setName(origName + " loading " + name);
                long start = System.nanoTime();
                try {
                    t = supplier.get();
                    t2.setName(origName);
                }
                catch (Throwable throwable) {
                    t2.setName(origName);
                    long ms = (System.nanoTime() - start) / 1000000L;
                    if (ms > 1000L) {
                        LOGGER.log(Level.INFO, "took {0}ms to load/not load {1} from {2}", new Object[]{ms, name, parentLoader});
                    }
                    throw throwable;
                }
                long ms = (System.nanoTime() - start) / 1000000L;
                if (ms > 1000L) {
                    LOGGER.log(Level.INFO, "took {0}ms to load/not load {1} from {2}", new Object[]{ms, name, parentLoader});
                }
                return t;
            });
        }
        catch (ExecutionException x) {
            throw new UncheckedExecutionException((Throwable)x);
        }
    }

    private static <T> LoadingCache<ClassLoader, Cache<String, T>> makeParentCache(boolean weakValues) {
        CacheBuilder builder = CacheBuilder.newBuilder().weakKeys();
        if (weakValues) {
            builder = builder.weakValues();
        }
        return builder.build(new CacheLoader<ClassLoader, Cache<String, T>>(){

            public Cache<String, T> load(ClassLoader parentLoader) {
                return CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
            }
        });
    }

    private static final class Unused {
        private Unused() {
        }
    }
}

