/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import com.google.common.collect.ImmutableList;
import groovy.lang.Grab;
import groovy.transform.ASTTest;
import java.lang.annotation.Annotation;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;

public class RejectASTTransformsCustomizer
extends CompilationCustomizer {
    private static final List<Class<? extends Annotation>> BLOCKED_TRANSFORMS = ImmutableList.of(ASTTest.class, Grab.class);

    public RejectASTTransformsCustomizer() {
        super(CompilePhase.CONVERSION);
    }

    public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
        new RejectASTTransformsVisitor(source).visitClass(classNode);
    }

    private static class RejectASTTransformsVisitor
    extends ClassCodeVisitorSupport {
        private SourceUnit source;

        public RejectASTTransformsVisitor(SourceUnit source) {
            this.source = source;
        }

        protected SourceUnit getSourceUnit() {
            return this.source;
        }

        public void visitAnnotations(AnnotatedNode node) {
            for (AnnotationNode an : node.getAnnotations()) {
                for (Class blockedAnnotation : BLOCKED_TRANSFORMS) {
                    if (!blockedAnnotation.getSimpleName().equals(an.getClassNode().getName())) continue;
                    throw new SecurityException("Annotation " + blockedAnnotation.getSimpleName() + " cannot be used in the sandbox.");
                }
            }
        }
    }
}

