/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import com.google.common.primitives.Primitives;
import groovy.lang.GString;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ClassUtils;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

class GroovyCallSiteSelector {
    private static boolean matches(@Nonnull Class<?>[] parameterTypes, @Nonnull Object[] parameters, boolean varargs) {
        if (varargs) {
            parameters = GroovyCallSiteSelector.parametersForVarargs(parameterTypes, parameters);
        }
        if (parameters.length != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameters[i] == null) {
                if (!parameterTypes[i].isPrimitive()) continue;
                return false;
            }
            if (parameterTypes[i].isInstance(parameters[i]) || parameterTypes[i].isPrimitive() && parameters[i] != null && GroovyCallSiteSelector.isInstancePrimitive(ClassUtils.primitiveToWrapper(parameterTypes[i]), parameters[i]) || parameterTypes[i] == String.class && parameters[i] instanceof GString) continue;
            return false;
        }
        return true;
    }

    private static Object[] parametersForVarargs(Class<?>[] parameterTypes, Object[] parameters) {
        int arrayLength;
        int fixedLen = parameterTypes.length - 1;
        Class componentType = parameterTypes[fixedLen].getComponentType();
        assert (componentType != null);
        if (componentType.isPrimitive()) {
            componentType = ClassUtils.primitiveToWrapper(componentType);
        }
        if ((arrayLength = parameters.length - fixedLen) >= 0) {
            if (arrayLength == 1 && parameterTypes[fixedLen].isInstance(parameters[fixedLen])) {
                return parameters;
            }
            if (arrayLength > 0 && (componentType.isInstance(parameters[fixedLen]) || parameters[fixedLen] == null) || arrayLength == 0) {
                Object array = DefaultTypeTransformation.castToVargsArray((Object[])parameters, (int)fixedLen, parameterTypes[fixedLen]);
                Object[] parameters2 = new Object[fixedLen + 1];
                System.arraycopy(parameters, 0, parameters2, 0, fixedLen);
                parameters2[fixedLen] = array;
                return parameters2;
            }
        }
        return parameters;
    }

    private static boolean isInstancePrimitive(@Nonnull Class<?> type, @Nonnull Object instance) {
        if (type.isInstance(instance)) {
            return true;
        }
        if (instance instanceof Number) {
            Long n;
            if (type == Long.class && instance instanceof Integer) {
                return true;
            }
            if (type == Integer.class && instance instanceof Long && (n = (Long)instance) >= Integer.MIN_VALUE && n <= Integer.MAX_VALUE) {
                return true;
            }
        }
        return false;
    }

    @CheckForNull
    public static Method method(@Nonnull Object receiver, @Nonnull String method, @Nonnull Object[] args) {
        Method candidate;
        for (Class<?> c : GroovyCallSiteSelector.types(receiver)) {
            Method candidate2 = GroovyCallSiteSelector.findMatchingMethod(c, method, args);
            if (candidate2 == null) continue;
            return candidate2;
        }
        if (receiver instanceof GString && (candidate = GroovyCallSiteSelector.findMatchingMethod(String.class, method, args)) != null) {
            return candidate;
        }
        return null;
    }

    @CheckForNull
    public static Constructor<?> constructor(@Nonnull Class<?> receiver, @Nonnull Object[] args) {
        Constructor<?>[] constructors = receiver.getDeclaredConstructors();
        Constructor<?> candidate = null;
        for (Constructor<?> c : constructors) {
            if (!GroovyCallSiteSelector.matches(c.getParameterTypes(), args, c.isVarArgs()) || candidate != null && !GroovyCallSiteSelector.isMoreSpecific(c, c.getParameterTypes(), c.isVarArgs(), candidate, candidate.getParameterTypes(), candidate.isVarArgs())) continue;
            candidate = c;
        }
        if (candidate != null) {
            return candidate;
        }
        if (args.length == 1 && args[0] instanceof Map) {
            for (Constructor<?> c : constructors) {
                if (c.getParameterTypes().length != 0 || c.isVarArgs()) continue;
                return c;
            }
        }
        return null;
    }

    @CheckForNull
    public static Method staticMethod(@Nonnull Class<?> receiver, @Nonnull String method, @Nonnull Object[] args) {
        return GroovyCallSiteSelector.findMatchingMethod(receiver, method, args);
    }

    private static Method findMatchingMethod(@Nonnull Class<?> receiver, @Nonnull String method, @Nonnull Object[] args) {
        Method candidate = null;
        for (Method m : receiver.getDeclaredMethods()) {
            if (m == null) continue;
            boolean isVarArgs = GroovyCallSiteSelector.isVarArgsMethod(m, args);
            if (!m.getName().equals(method) || !GroovyCallSiteSelector.matches(m.getParameterTypes(), args, isVarArgs) || candidate != null && !GroovyCallSiteSelector.isMoreSpecific(m, m.getParameterTypes(), isVarArgs, candidate, candidate.getParameterTypes(), GroovyCallSiteSelector.isVarArgsMethod(candidate, args))) continue;
            candidate = m;
        }
        return candidate;
    }

    private static boolean isVarArgsMethod(@Nonnull Method m, @Nonnull Object[] args) {
        if (m.isVarArgs()) {
            return true;
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes.length < 2) {
            return false;
        }
        int lastIndex = paramTypes.length - 1;
        if (paramTypes[lastIndex].isArray() && args.length > paramTypes.length) {
            Class<?> lastClass = paramTypes[lastIndex].getComponentType();
            for (int i = lastIndex; i < args.length; ++i) {
                if (args[i] == null || lastClass.isAssignableFrom(args[i].getClass())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @CheckForNull
    public static Field field(@Nonnull Object receiver, @Nonnull String field) {
        for (Class<?> c : GroovyCallSiteSelector.types(receiver)) {
            for (Field f : c.getDeclaredFields()) {
                if (!f.getName().equals(field)) continue;
                return f;
            }
        }
        return null;
    }

    @CheckForNull
    public static Field staticField(@Nonnull Class<?> receiver, @Nonnull String field) {
        for (Field f : receiver.getDeclaredFields()) {
            if (!f.getName().equals(field)) continue;
            return f;
        }
        return null;
    }

    private static Iterable<Class<?>> types(@Nonnull Object o) {
        LinkedHashSet types = new LinkedHashSet();
        GroovyCallSiteSelector.visitTypes(types, o.getClass());
        return types;
    }

    private static void visitTypes(@Nonnull Set<Class<?>> types, @Nonnull Class<?> c) {
        Class<?> s = c.getSuperclass();
        if (s != null) {
            GroovyCallSiteSelector.visitTypes(types, s);
        }
        for (Class<?> i : c.getInterfaces()) {
            GroovyCallSiteSelector.visitTypes(types, i);
        }
        types.add(c);
    }

    private static boolean isMoreSpecific(AccessibleObject more, Class<?>[] moreParams, boolean moreVarArgs, AccessibleObject less, Class<?>[] lessParams, boolean lessVarArgs) {
        if (lessVarArgs && !moreVarArgs) {
            return true;
        }
        if (!lessVarArgs && moreVarArgs) {
            return false;
        }
        if (moreParams.length != lessParams.length) {
            throw new IllegalStateException("cannot compare " + more + " to " + less);
        }
        for (int i = 0; i < moreParams.length; ++i) {
            Class lessParam;
            Class moreParam = Primitives.wrap(moreParams[i]);
            if (moreParam.isAssignableFrom(lessParam = Primitives.wrap(lessParams[i]))) {
                return false;
            }
            if (lessParam.isAssignableFrom(moreParam)) {
                return true;
            }
            if (moreParam == Long.class && lessParam == Integer.class) {
                return false;
            }
            if (moreParam != Integer.class || lessParam != Long.class) continue;
            return true;
        }
        return more.toString().compareTo(less.toString()) > 0;
    }

    private GroovyCallSiteSelector() {
    }
}

