/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.EnumeratingWhitelist;

public class ProxyWhitelist
extends Whitelist {
    @GuardedBy(value="lock")
    private Collection<? extends Whitelist> originalDelegates;
    @GuardedBy(value="lock")
    final List<Whitelist> delegates = new ArrayList<Whitelist>();
    @GuardedBy(value="lock")
    private final List<EnumeratingWhitelist.MethodSignature> methodSignatures = new ArrayList<EnumeratingWhitelist.MethodSignature>();
    @GuardedBy(value="lock")
    private final List<EnumeratingWhitelist.NewSignature> newSignatures = new ArrayList<EnumeratingWhitelist.NewSignature>();
    @GuardedBy(value="lock")
    private final List<EnumeratingWhitelist.MethodSignature> staticMethodSignatures = new ArrayList<EnumeratingWhitelist.MethodSignature>();
    @GuardedBy(value="lock")
    private final List<EnumeratingWhitelist.FieldSignature> fieldSignatures = new ArrayList<EnumeratingWhitelist.FieldSignature>();
    @GuardedBy(value="lock")
    private final List<EnumeratingWhitelist.FieldSignature> staticFieldSignatures = new ArrayList<EnumeratingWhitelist.FieldSignature>();
    private final Map<ProxyWhitelist, Void> wrappers = new WeakHashMap<ProxyWhitelist, Void>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public ProxyWhitelist(Collection<? extends Whitelist> delegates) {
        this.reset(delegates);
    }

    private void reset() {
        this.reset(this.originalDelegates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset(Collection<? extends Whitelist> delegates) {
        ReentrantReadWriteLock.WriteLock writer = this.lock.writeLock();
        writer.lock();
        try {
            this.originalDelegates = delegates;
            this.delegates.clear();
            this.methodSignatures.clear();
            this.newSignatures.clear();
            this.staticMethodSignatures.clear();
            this.fieldSignatures.clear();
            this.delegates.add(new EnumeratingWhitelist(){

                @Override
                protected List<EnumeratingWhitelist.MethodSignature> methodSignatures() {
                    return ProxyWhitelist.this.methodSignatures;
                }

                @Override
                protected List<EnumeratingWhitelist.NewSignature> newSignatures() {
                    return ProxyWhitelist.this.newSignatures;
                }

                @Override
                protected List<EnumeratingWhitelist.MethodSignature> staticMethodSignatures() {
                    return ProxyWhitelist.this.staticMethodSignatures;
                }

                @Override
                protected List<EnumeratingWhitelist.FieldSignature> fieldSignatures() {
                    return ProxyWhitelist.this.fieldSignatures;
                }

                @Override
                protected List<EnumeratingWhitelist.FieldSignature> staticFieldSignatures() {
                    return ProxyWhitelist.this.staticFieldSignatures;
                }
            });
            for (Whitelist whitelist : delegates) {
                if (whitelist instanceof EnumeratingWhitelist) {
                    EnumeratingWhitelist ew = (EnumeratingWhitelist)whitelist;
                    this.methodSignatures.addAll(ew.methodSignatures());
                    this.newSignatures.addAll(ew.newSignatures());
                    this.staticMethodSignatures.addAll(ew.staticMethodSignatures());
                    this.fieldSignatures.addAll(ew.fieldSignatures());
                    this.staticFieldSignatures.addAll(ew.staticFieldSignatures());
                    ew.clearCache();
                    continue;
                }
                if (whitelist instanceof ProxyWhitelist) {
                    ProxyWhitelist pw = (ProxyWhitelist)whitelist;
                    pw.wrappers.put(this, null);
                    for (Whitelist subdelegate : pw.delegates) {
                        if (subdelegate instanceof EnumeratingWhitelist) {
                            ((EnumeratingWhitelist)subdelegate).clearCache();
                            continue;
                        }
                        this.delegates.add(subdelegate);
                    }
                    this.methodSignatures.addAll(pw.methodSignatures);
                    this.newSignatures.addAll(pw.newSignatures);
                    this.staticMethodSignatures.addAll(pw.staticMethodSignatures);
                    this.fieldSignatures.addAll(pw.fieldSignatures);
                    this.staticFieldSignatures.addAll(pw.staticFieldSignatures);
                    continue;
                }
                this.delegates.add(whitelist);
            }
            for (ProxyWhitelist proxyWhitelist : this.wrappers.keySet()) {
                proxyWhitelist.reset();
            }
            if (this.wrappers.isEmpty()) {
                ((EnumeratingWhitelist)this.delegates.get(0)).precache();
            }
        }
        finally {
            writer.unlock();
        }
    }

    public ProxyWhitelist(Whitelist ... delegates) {
        this(Arrays.asList(delegates));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsMethod(Method method, Object receiver, Object[] args) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsMethod(method, receiver, args)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsConstructor(constructor, args)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsStaticMethod(Method method, Object[] args) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsStaticMethod(method, args)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsFieldGet(Field field, Object receiver) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsFieldGet(field, receiver)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsFieldSet(Field field, Object receiver, Object value) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsFieldSet(field, receiver, value)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsStaticFieldGet(Field field) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsStaticFieldGet(field)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean permitsStaticFieldSet(Field field, Object value) {
        this.lock.readLock().lock();
        try {
            for (Whitelist delegate : this.delegates) {
                if (!delegate.permitsStaticFieldSet(field, value)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return false;
    }
}

