/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Script;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.ClassLoaderWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SandboxInterceptor;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SandboxResolvingClassLoader;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.ProxyWhitelist;
import org.kohsuke.groovy.sandbox.SandboxTransformer;

public class GroovySandbox {
    @Nonnull
    public static CompilerConfiguration createSecureCompilerConfiguration() {
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.addCompilationCustomizers(new CompilationCustomizer[]{new SandboxTransformer()});
        return cc;
    }

    @Nonnull
    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Should be managed by the caller.")
    public static ClassLoader createSecureClassLoader(ClassLoader base) {
        return new SandboxResolvingClassLoader(base);
    }

    public static void runInSandbox(@Nonnull Runnable r, @Nonnull Whitelist whitelist) throws RejectedAccessException {
        SandboxInterceptor sandbox = new SandboxInterceptor(whitelist);
        sandbox.register();
        try {
            r.run();
        }
        finally {
            sandbox.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V runInSandbox(@Nonnull Callable<V> c, @Nonnull Whitelist whitelist) throws Exception {
        SandboxInterceptor sandbox = new SandboxInterceptor(whitelist);
        sandbox.register();
        try {
            V v = c.call();
            return v;
        }
        finally {
            sandbox.unregister();
        }
    }

    @Deprecated
    public static void runInSandbox(final @Nonnull Script script, @Nonnull Whitelist whitelist) throws RejectedAccessException {
        GroovySandbox.runInSandbox(new Runnable(){

            @Override
            public void run() {
                script.run();
            }
        }, whitelist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object run(@Nonnull Script script, @Nonnull Whitelist whitelist) throws RejectedAccessException {
        ProxyWhitelist wrapperWhitelist = new ProxyWhitelist(new ClassLoaderWhitelist(script.getClass().getClassLoader()), whitelist);
        SandboxInterceptor sandbox = new SandboxInterceptor(wrapperWhitelist);
        sandbox.register();
        try {
            Object object = script.run();
            return object;
        }
        finally {
            sandbox.unregister();
        }
    }

    private GroovySandbox() {
    }
}

