/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

class SandboxResolvingClassLoader
extends ClassLoader {
    private static final Logger LOGGER = Logger.getLogger(SandboxResolvingClassLoader.class.getName());
    private static final LoadingCache<ClassLoader, LoadingCache<String, Optional<Class>>> parentClassCache = SandboxResolvingClassLoader.makeParentCache(new CacheFunction<Optional<Class>>(){

        @Override
        public Optional<Class> compute(ClassLoader parentLoader, String name) {
            try {
                Class<?> c = parentLoader.loadClass(name);
                return Optional.of(c);
            }
            catch (ClassNotFoundException x) {
                return Optional.absent();
            }
        }
    });
    private static final LoadingCache<ClassLoader, LoadingCache<String, Optional<URL>>> parentResourceCache = SandboxResolvingClassLoader.makeParentCache(new CacheFunction<Optional<URL>>(){

        @Override
        public Optional<URL> compute(ClassLoader parentLoader, String name) {
            return Optional.fromNullable((Object)parentLoader.getResource(name));
        }
    });

    SandboxResolvingClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("org.kohsuke.groovy.sandbox.")) {
            return this.getClass().getClassLoader().loadClass(name);
        }
        Class c = (Class)((Optional)((LoadingCache)parentClassCache.getUnchecked((Object)this.getParent())).getUnchecked((Object)name)).orNull();
        if (c != null) {
            if (resolve) {
                super.resolveClass(c);
            }
            return c;
        }
        throw new ClassNotFoundException(name){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
    }

    @Override
    public URL getResource(String name) {
        return (URL)((Optional)((LoadingCache)parentResourceCache.getUnchecked((Object)this.getParent())).getUnchecked((Object)name)).orNull();
    }

    private static <T> LoadingCache<ClassLoader, LoadingCache<String, T>> makeParentCache(final CacheFunction<T> function) {
        return CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<ClassLoader, LoadingCache<String, T>>(){

            public LoadingCache<String, T> load(final ClassLoader parentLoader) {
                return CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build(new CacheLoader<String, T>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public T load(String name) {
                        Object t;
                        Thread t2 = Thread.currentThread();
                        String origName = t2.getName();
                        t2.setName(origName + " loading " + name);
                        long start = System.nanoTime();
                        try {
                            t = function.compute(parentLoader, name);
                            t2.setName(origName);
                        }
                        catch (Throwable throwable) {
                            t2.setName(origName);
                            long ms = (System.nanoTime() - start) / 1000000L;
                            if (ms > 250L) {
                                LOGGER.log(Level.WARNING, "took {0}ms to load/not load {1} from {2}", new Object[]{ms, name, parentLoader});
                            }
                            throw throwable;
                        }
                        long ms = (System.nanoTime() - start) / 1000000L;
                        if (ms > 250L) {
                            LOGGER.log(Level.WARNING, "took {0}ms to load/not load {1} from {2}", new Object[]{ms, name, parentLoader});
                        }
                        return t;
                    }
                });
            }
        });
    }

    private static interface CacheFunction<T> {
        public T compute(ClassLoader var1, String var2);
    }
}

