/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import hudson.Functions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.codehaus.groovy.runtime.DateGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.ProcessGroovyMethods;
import org.codehaus.groovy.runtime.SqlGroovyMethods;
import org.codehaus.groovy.runtime.SwingGroovyMethods;
import org.codehaus.groovy.runtime.XmlGroovyMethods;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovyCallSiteSelector;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.EnumeratingWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.StaticWhitelist;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;

final class SandboxInterceptor
extends GroovyInterceptor {
    private final Whitelist whitelist;
    private static final Class<?>[] DGM_CLASSES = new Class[]{DefaultGroovyMethods.class, SwingGroovyMethods.class, SqlGroovyMethods.class, XmlGroovyMethods.class, EncodingGroovyMethods.class, DateGroovyMethods.class, ProcessGroovyMethods.class};

    SandboxInterceptor(Whitelist whitelist) {
        this.whitelist = whitelist;
    }

    public Object onMethodCall(GroovyInterceptor.Invoker invoker, Object receiver, String method, Object ... args) throws Throwable {
        Method m = GroovyCallSiteSelector.method(receiver, method, args);
        if (m == null) {
            if (receiver instanceof Number || receiver instanceof String && method.equals("plus")) {
                return super.onMethodCall(invoker, receiver, method, args);
            }
            Object[] selfArgs = new Object[args.length + 1];
            selfArgs[0] = receiver;
            System.arraycopy(args, 0, selfArgs, 1, args.length);
            for (Class<?> dgmClass : DGM_CLASSES) {
                Method dgmMethod = GroovyCallSiteSelector.staticMethod(dgmClass, method, selfArgs);
                if (dgmMethod == null) continue;
                if (this.whitelist.permitsStaticMethod(dgmMethod, selfArgs)) {
                    return super.onMethodCall(invoker, receiver, method, args);
                }
                throw StaticWhitelist.rejectStaticMethod(dgmMethod);
            }
            try {
                receiver.getClass().getMethod("invokeMethod", String.class, Object.class);
                return this.onMethodCall(invoker, receiver, "invokeMethod", method, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RejectedAccessException("unclassified method " + EnumeratingWhitelist.getName(receiver.getClass()) + " " + method + SandboxInterceptor.printArgumentTypes(args));
            }
        }
        if (this.whitelist.permitsMethod(m, receiver, args)) {
            return super.onMethodCall(invoker, receiver, method, args);
        }
        if (method.equals("invokeMethod") && args.length == 2 && args[0] instanceof String && args[1] instanceof Object[]) {
            throw StaticWhitelist.rejectMethod(m, EnumeratingWhitelist.getName(receiver.getClass()) + " " + args[0] + SandboxInterceptor.printArgumentTypes((Object[])args[1]));
        }
        throw StaticWhitelist.rejectMethod(m);
    }

    public Object onNewInstance(GroovyInterceptor.Invoker invoker, Class receiver, Object ... args) throws Throwable {
        Constructor<?> c = GroovyCallSiteSelector.constructor(receiver, args);
        if (c == null) {
            throw new RejectedAccessException("unclassified new " + EnumeratingWhitelist.getName(receiver) + SandboxInterceptor.printArgumentTypes(args));
        }
        if (this.whitelist.permitsConstructor(c, args)) {
            return super.onNewInstance(invoker, receiver, args);
        }
        throw StaticWhitelist.rejectNew(c);
    }

    public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
        Method m = GroovyCallSiteSelector.staticMethod(receiver, method, args);
        if (m == null) {
            throw new RejectedAccessException("unclassified staticMethod " + EnumeratingWhitelist.getName(receiver) + " " + method + SandboxInterceptor.printArgumentTypes(args));
        }
        if (this.whitelist.permitsStaticMethod(m, args)) {
            return super.onStaticCall(invoker, receiver, method, args);
        }
        throw StaticWhitelist.rejectStaticMethod(m);
    }

    public Object onSetProperty(GroovyInterceptor.Invoker invoker, final Object receiver, final String property, Object value) throws Throwable {
        Field instanceField;
        Object[] propertyValueArgs;
        Method setPropertyMethod;
        if (receiver instanceof Script && !property.equals("binding") && !property.equals("metaClass")) {
            return super.onSetProperty(invoker, receiver, property, value);
        }
        Rejector rejector = null;
        Object[] valueArg = new Object[]{value};
        String setter = "set" + Functions.capitalize((String)property);
        final Method setterMethod = GroovyCallSiteSelector.method(receiver, setter, valueArg);
        if (setterMethod != null) {
            if (this.whitelist.permitsMethod(setterMethod, receiver, valueArg)) {
                return super.onSetProperty(invoker, receiver, property, value);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(setterMethod);
                    }
                };
            }
        }
        if ((setPropertyMethod = GroovyCallSiteSelector.method(receiver, "setProperty", propertyValueArgs = new Object[]{property, value})) != null) {
            if (this.whitelist.permitsMethod(setPropertyMethod, receiver, propertyValueArgs)) {
                return super.onSetProperty(invoker, receiver, property, value);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(setPropertyMethod, receiver.getClass().getName() + "." + property);
                    }
                };
            }
        }
        if ((instanceField = GroovyCallSiteSelector.field(receiver, property)) != null) {
            if (this.whitelist.permitsFieldSet(instanceField, receiver, value)) {
                return super.onSetProperty(invoker, receiver, property, value);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectField(instanceField);
                    }
                };
            }
        }
        if (receiver instanceof Class) {
            Field staticField;
            final Method staticSetterMethod = GroovyCallSiteSelector.staticMethod((Class)receiver, setter, valueArg);
            if (staticSetterMethod != null) {
                if (this.whitelist.permitsStaticMethod(staticSetterMethod, valueArg)) {
                    return super.onSetProperty(invoker, receiver, property, value);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticMethod(staticSetterMethod);
                        }
                    };
                }
            }
            if ((staticField = GroovyCallSiteSelector.staticField((Class)receiver, property)) != null) {
                if (this.whitelist.permitsStaticFieldSet(staticField, value)) {
                    return super.onSetProperty(invoker, receiver, property, value);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticField(staticField);
                        }
                    };
                }
            }
        }
        throw rejector != null ? rejector.reject() : SandboxInterceptor.unclassifiedField(receiver, property);
    }

    public Object onGetProperty(GroovyInterceptor.Invoker invoker, final Object receiver, final String property) throws Throwable {
        Object[] propertyArg;
        Method getPropertyMethod;
        String booleanGetter;
        Method booleanGetterMethod;
        MissingPropertyException mpe = null;
        if (receiver instanceof Script) {
            try {
                ((Script)receiver).getBinding().getVariable(property);
                return super.onGetProperty(invoker, receiver, property);
            }
            catch (MissingPropertyException x) {
                mpe = x;
            }
        }
        if (property.equals("length") && receiver.getClass().isArray()) {
            return super.onGetProperty(invoker, receiver, property);
        }
        Rejector rejector = null;
        Object[] noArgs = new Object[]{};
        String getter = "get" + Functions.capitalize((String)property);
        final Method getterMethod = GroovyCallSiteSelector.method(receiver, getter, noArgs);
        if (getterMethod != null) {
            if (this.whitelist.permitsMethod(getterMethod, receiver, noArgs)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(getterMethod);
                    }
                };
            }
        }
        if ((booleanGetterMethod = GroovyCallSiteSelector.method(receiver, booleanGetter = "is" + Functions.capitalize((String)property), noArgs)) != null && booleanGetterMethod.getReturnType() == Boolean.TYPE) {
            if (this.whitelist.permitsMethod(booleanGetterMethod, receiver, noArgs)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(booleanGetterMethod);
                    }
                };
            }
        }
        Object[] selfArgs = new Object[]{receiver};
        for (Class<?> dgmClass : DGM_CLASSES) {
            Method dgmBooleanGetterMethod;
            final Method dgmGetterMethod = GroovyCallSiteSelector.staticMethod(dgmClass, getter, selfArgs);
            if (dgmGetterMethod != null) {
                if (this.whitelist.permitsStaticMethod(dgmGetterMethod, selfArgs)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticMethod(dgmGetterMethod);
                        }
                    };
                }
            }
            if ((dgmBooleanGetterMethod = GroovyCallSiteSelector.staticMethod(dgmClass, booleanGetter, selfArgs)) == null || dgmBooleanGetterMethod.getReturnType() != Boolean.TYPE) continue;
            if (this.whitelist.permitsStaticMethod(dgmBooleanGetterMethod, selfArgs)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector != null) continue;
            rejector = new Rejector(){

                @Override
                public RejectedAccessException reject() {
                    return StaticWhitelist.rejectStaticMethod(dgmBooleanGetterMethod);
                }
            };
        }
        final Field instanceField = GroovyCallSiteSelector.field(receiver, property);
        if (instanceField != null) {
            if (this.whitelist.permitsFieldGet(instanceField, receiver)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectField(instanceField);
                    }
                };
            }
        }
        if ((getPropertyMethod = GroovyCallSiteSelector.method(receiver, "getProperty", propertyArg = new Object[]{property})) != null) {
            if (this.whitelist.permitsMethod(getPropertyMethod, receiver, propertyArg)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(getPropertyMethod, receiver.getClass().getName() + "." + property);
                    }
                };
            }
        }
        if (receiver instanceof Class) {
            Field staticField;
            Method staticBooleanGetterMethod;
            final Method staticGetterMethod = GroovyCallSiteSelector.staticMethod((Class)receiver, getter, noArgs);
            if (staticGetterMethod != null) {
                if (this.whitelist.permitsStaticMethod(staticGetterMethod, noArgs)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticMethod(staticGetterMethod);
                        }
                    };
                }
            }
            if ((staticBooleanGetterMethod = GroovyCallSiteSelector.staticMethod((Class)receiver, booleanGetter, noArgs)) != null && staticBooleanGetterMethod.getReturnType() == Boolean.TYPE) {
                if (this.whitelist.permitsStaticMethod(staticBooleanGetterMethod, noArgs)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticMethod(staticBooleanGetterMethod);
                        }
                    };
                }
            }
            if ((staticField = GroovyCallSiteSelector.staticField((Class)receiver, property)) != null) {
                if (this.whitelist.permitsStaticFieldGet(staticField)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticField(staticField);
                        }
                    };
                }
            }
        }
        if (mpe != null) {
            throw mpe;
        }
        throw rejector != null ? rejector.reject() : SandboxInterceptor.unclassifiedField(receiver, property);
    }

    private static RejectedAccessException unclassifiedField(Object receiver, String property) {
        return new RejectedAccessException("unclassified field " + EnumeratingWhitelist.getName(receiver.getClass()) + " " + property);
    }

    private static String printArgumentTypes(Object[] args) {
        StringBuilder b = new StringBuilder();
        for (Object arg : args) {
            b.append(' ');
            b.append(arg == null ? "null" : EnumeratingWhitelist.getName(arg.getClass()));
        }
        return b.toString();
    }

    private static interface Rejector {
        @Nonnull
        public RejectedAccessException reject();
    }
}

