/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import hudson.Functions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovyCallSiteSelector;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.EnumeratingWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.StaticWhitelist;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;

final class SandboxInterceptor
extends GroovyInterceptor {
    private final Whitelist whitelist;

    SandboxInterceptor(Whitelist whitelist) {
        this.whitelist = whitelist;
    }

    public Object onMethodCall(GroovyInterceptor.Invoker invoker, Object receiver, String method, Object ... args) throws Throwable {
        Method m = GroovyCallSiteSelector.method(receiver, method, args);
        if (m == null) {
            if (receiver instanceof Number || receiver instanceof String && method.equals("plus")) {
                return super.onMethodCall(invoker, receiver, method, args);
            }
            Object[] selfArgs = new Object[args.length + 1];
            selfArgs[0] = receiver;
            System.arraycopy(args, 0, selfArgs, 1, args.length);
            if (GroovyCallSiteSelector.staticMethod(DefaultGroovyMethods.class, method, selfArgs) != null) {
                return this.onStaticCall(invoker, DefaultGroovyMethods.class, method, selfArgs);
            }
            try {
                receiver.getClass().getMethod("invokeMethod", String.class, Object.class);
                return this.onMethodCall(invoker, receiver, "invokeMethod", method, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RejectedAccessException("unclassified method " + EnumeratingWhitelist.getName(receiver.getClass()) + " " + method + SandboxInterceptor.printArgumentTypes(args));
            }
        }
        if (this.whitelist.permitsMethod(m, receiver, args)) {
            return super.onMethodCall(invoker, receiver, method, args);
        }
        if (method.equals("invokeMethod") && args.length == 2 && args[0] instanceof String && args[1] instanceof Object[]) {
            throw StaticWhitelist.rejectMethod(m, EnumeratingWhitelist.getName(receiver.getClass()) + " " + args[0] + SandboxInterceptor.printArgumentTypes((Object[])args[1]));
        }
        throw StaticWhitelist.rejectMethod(m);
    }

    public Object onNewInstance(GroovyInterceptor.Invoker invoker, Class receiver, Object ... args) throws Throwable {
        Constructor<?> c = GroovyCallSiteSelector.constructor(receiver, args);
        if (c == null) {
            throw new RejectedAccessException("unclassified new " + EnumeratingWhitelist.getName(receiver) + SandboxInterceptor.printArgumentTypes(args));
        }
        if (this.whitelist.permitsConstructor(c, args)) {
            return super.onNewInstance(invoker, receiver, args);
        }
        throw StaticWhitelist.rejectNew(c);
    }

    public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
        Method m = GroovyCallSiteSelector.staticMethod(receiver, method, args);
        if (m == null) {
            throw new RejectedAccessException("unclassified staticMethod " + EnumeratingWhitelist.getName(receiver) + " " + method + SandboxInterceptor.printArgumentTypes(args));
        }
        if (this.whitelist.permitsStaticMethod(m, args)) {
            return super.onStaticCall(invoker, receiver, method, args);
        }
        throw StaticWhitelist.rejectStaticMethod(m);
    }

    @SuppressWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public Object onSetProperty(GroovyInterceptor.Invoker invoker, Object receiver, String property, Object value) throws Throwable {
        if (receiver instanceof Script && !property.equals("binding") && !property.equals("metaClass")) {
            return super.onSetProperty(invoker, receiver, property, value);
        }
        Field f = GroovyCallSiteSelector.field(receiver, property);
        if (f != null && this.whitelist.permitsFieldSet(f, receiver, value)) {
            return super.onSetProperty(invoker, receiver, property, value);
        }
        Object[] args1 = new Object[]{value};
        String setter = "set" + Functions.capitalize((String)property);
        Method m = GroovyCallSiteSelector.method(receiver, setter, args1);
        if (m != null && this.whitelist.permitsMethod(m, receiver, args1)) {
            return super.onSetProperty(invoker, receiver, property, value);
        }
        Object[] args2 = new Object[]{property, value};
        Method m2 = GroovyCallSiteSelector.method(receiver, "setProperty", args2);
        if (m2 != null && this.whitelist.permitsMethod(m2, receiver, args2)) {
            return super.onSetProperty(invoker, receiver, property, value);
        }
        Field f2 = null;
        Method m3 = null;
        if (receiver instanceof Class) {
            f2 = GroovyCallSiteSelector.staticField((Class)receiver, property);
            if (f2 != null && this.whitelist.permitsStaticFieldSet(f2, value)) {
                return super.onSetProperty(invoker, receiver, property, value);
            }
            m3 = GroovyCallSiteSelector.staticMethod((Class)receiver, setter, args1);
            if (m3 != null && this.whitelist.permitsStaticMethod(m3, args1)) {
                return super.onSetProperty(invoker, receiver, property, value);
            }
        }
        throw SandboxInterceptor.rejectField(f, m, m2, f2, m3, receiver, property);
    }

    @SuppressWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public Object onGetProperty(GroovyInterceptor.Invoker invoker, Object receiver, String property) throws Throwable {
        MissingPropertyException mpe = null;
        if (receiver instanceof Script) {
            try {
                ((Script)receiver).getBinding().getVariable(property);
                return super.onGetProperty(invoker, receiver, property);
            }
            catch (MissingPropertyException x) {
                mpe = x;
            }
        }
        if (property.equals("length") && receiver.getClass().isArray()) {
            return super.onGetProperty(invoker, receiver, property);
        }
        Field f = GroovyCallSiteSelector.field(receiver, property);
        if (f != null && this.whitelist.permitsFieldGet(f, receiver)) {
            return super.onGetProperty(invoker, receiver, property);
        }
        Object[] args0 = new Object[]{};
        String getter = "get" + Functions.capitalize((String)property);
        Method m = GroovyCallSiteSelector.method(receiver, getter, args0);
        if (m != null && this.whitelist.permitsMethod(m, receiver, args0)) {
            return super.onGetProperty(invoker, receiver, property);
        }
        Object[] args1 = new Object[]{property};
        Method m2 = GroovyCallSiteSelector.method(receiver, "getProperty", args1);
        if (m2 != null && this.whitelist.permitsMethod(m2, receiver, args1)) {
            return super.onGetProperty(invoker, receiver, property);
        }
        Field f2 = null;
        Method m3 = null;
        if (receiver instanceof Class) {
            f2 = GroovyCallSiteSelector.staticField((Class)receiver, property);
            if (f2 != null && this.whitelist.permitsStaticFieldGet(f2)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            m3 = GroovyCallSiteSelector.staticMethod((Class)receiver, getter, args0);
            if (m3 != null && this.whitelist.permitsStaticMethod(m3, args0)) {
                return super.onGetProperty(invoker, receiver, property);
            }
        }
        if (mpe != null) {
            throw mpe;
        }
        throw SandboxInterceptor.rejectField(f, m, m2, f2, m3, receiver, property);
    }

    private static RejectedAccessException rejectField(Field f, Method m, Method m2, Field f2, Method m3, Object receiver, String property) {
        if (f == null) {
            if (m == null) {
                if (m2 == null) {
                    if (f2 == null) {
                        if (m3 == null) {
                            return new RejectedAccessException("unclassified field " + EnumeratingWhitelist.getName(receiver.getClass()) + " " + property);
                        }
                        return StaticWhitelist.rejectStaticMethod(m3);
                    }
                    return StaticWhitelist.rejectStaticField(f2);
                }
                return StaticWhitelist.rejectMethod(m2, receiver.getClass().getName() + "." + property);
            }
            return StaticWhitelist.rejectMethod(m);
        }
        return StaticWhitelist.rejectField(f);
    }

    private static String printArgumentTypes(Object[] args) {
        StringBuilder b = new StringBuilder();
        for (Object arg : args) {
            b.append(' ');
            b.append(arg == null ? "null" : EnumeratingWhitelist.getName(arg.getClass()));
        }
        return b.toString();
    }
}

