/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassLoaderWhitelist
extends Whitelist {
    private final ClassLoader scriptLoader;

    public ClassLoaderWhitelist(ClassLoader scriptLoader) {
        this.scriptLoader = scriptLoader;
    }

    private boolean permits(Class<?> declaringClass) {
        return declaringClass.getClassLoader() == this.scriptLoader;
    }

    @Override
    public boolean permitsMethod(Method method, Object receiver, Object[] args) {
        return this.permits(method.getDeclaringClass());
    }

    @Override
    public boolean permitsConstructor(Constructor<?> constructor, Object[] args) {
        return this.permits(constructor.getDeclaringClass());
    }

    @Override
    public boolean permitsStaticMethod(Method method, Object[] args) {
        return this.permits(method.getDeclaringClass());
    }

    @Override
    public boolean permitsFieldGet(Field field, Object receiver) {
        return this.permits(field.getDeclaringClass());
    }

    @Override
    public boolean permitsFieldSet(Field field, Object receiver, Object value) {
        return this.permits(field.getDeclaringClass());
    }

    @Override
    public boolean permitsStaticFieldGet(Field field) {
        return this.permits(field.getDeclaringClass());
    }

    @Override
    public boolean permitsStaticFieldSet(Field field, Object value) {
        return this.permits(field.getDeclaringClass());
    }
}

