/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import java.util.ArrayList;
import java.util.List;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.trait.SCMNavigatorContext;
import jenkins.scm.api.trait.SCMNavigatorTraitDescriptor;
import jenkins.scm.api.trait.SCMSourceBuilder;
import jenkins.scm.api.trait.SCMTrait;

public abstract class SCMNavigatorTrait
extends SCMTrait<SCMNavigatorTrait> {
    public final void applyToContext(SCMNavigatorContext<?, ?> context) {
        SCMNavigatorTraitDescriptor d = this.getDescriptor();
        if (d.getContextClass().isInstance(context) && d.isApplicableToContext(context.getClass())) {
            this.decorateContext(context);
        }
    }

    protected void decorateContext(SCMNavigatorContext<?, ?> context) {
    }

    @NonNull
    public final SCMSourceObserver applyToObserver(@NonNull SCMSourceObserver observer) {
        return this.decorateObserver(observer);
    }

    @NonNull
    protected SCMSourceObserver decorateObserver(@NonNull SCMSourceObserver observer) {
        return observer;
    }

    public final void applyToBuilder(SCMSourceBuilder<?, ?> builder) {
        SCMNavigatorTraitDescriptor d = this.getDescriptor();
        if (d.getBuilderClass().isInstance(builder) && d.isApplicableToBuilder(builder)) {
            this.decorateBuilder(builder);
        }
    }

    protected void decorateBuilder(SCMSourceBuilder<?, ?> builder) {
    }

    public final boolean isCategoryEnabled(@NonNull SCMHeadCategory category) {
        return this.includeCategory(category);
    }

    protected boolean includeCategory(@NonNull SCMHeadCategory category) {
        return false;
    }

    @Override
    public SCMNavigatorTraitDescriptor getDescriptor() {
        return (SCMNavigatorTraitDescriptor)super.getDescriptor();
    }

    public static DescriptorExtensionList<SCMNavigatorTrait, SCMNavigatorTraitDescriptor> all() {
        return SCMTrait.all(SCMNavigatorTrait.class);
    }

    public static List<SCMNavigatorTraitDescriptor> _for(@CheckForNull Class<? extends SCMNavigatorContext> contextClass, @CheckForNull Class<? extends SCMSourceBuilder> builderClass) {
        return SCMNavigatorTrait._for(null, contextClass, builderClass);
    }

    public static List<SCMNavigatorTraitDescriptor> _for(@CheckForNull SCMNavigatorDescriptor scmNavigator, @CheckForNull Class<? extends SCMNavigatorContext> contextClass, @CheckForNull Class<? extends SCMSourceBuilder> builderClass) {
        ArrayList<SCMNavigatorTraitDescriptor> result = new ArrayList<SCMNavigatorTraitDescriptor>();
        if (scmNavigator != null) {
            for (SCMNavigatorTraitDescriptor d : SCMNavigatorTrait.all()) {
                if (contextClass != null && !d.isApplicableToContext(contextClass) || builderClass != null && !d.isApplicableToBuilder(builderClass) || !d.isApplicableTo(scmNavigator)) continue;
                result.add(d);
            }
        } else {
            for (SCMNavigatorTraitDescriptor d : SCMNavigatorTrait.all()) {
                if (contextClass != null && !d.isApplicableToContext(contextClass) || builderClass != null && !d.isApplicableToBuilder(builderClass)) continue;
                result.add(d);
            }
        }
        return result;
    }
}

