/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.trait;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.OverrideMustInvoke;
import hudson.model.Descriptor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.SCMHeadMixin;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMSourceRequest;
import org.jvnet.tiger_types.Types;

public abstract class SCMHeadAuthorityDescriptor
extends Descriptor<SCMHeadAuthority<?, ?, ?>> {
    private final Class<? extends SCMSourceRequest> requestClass;
    private final Class<? extends SCMHeadMixin> headClass;
    private final Class<? extends SCMRevision> revisionClass;

    protected SCMHeadAuthorityDescriptor(Class<? extends SCMHeadAuthority<?, ?, ?>> clazz, Class<? extends SCMSourceRequest> requestClass, Class<? extends SCMHeadMixin> headClass, Class<? extends SCMRevision> revisionClass) {
        super(clazz);
        this.requestClass = requestClass;
        this.headClass = headClass;
        this.revisionClass = revisionClass;
    }

    protected SCMHeadAuthorityDescriptor() {
        Type bt = Types.getBaseClass((Type)this.clazz, SCMHeadAuthority.class);
        if (bt instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)bt;
            this.requestClass = Types.erasure((Type)pt.getActualTypeArguments()[0]);
            this.headClass = Types.erasure((Type)pt.getActualTypeArguments()[1]);
            this.revisionClass = Types.erasure((Type)pt.getActualTypeArguments()[2]);
            if (!SCMSourceRequest.class.isAssignableFrom(this.requestClass)) {
                throw new AssertionError((Object)"Failed to correctly detect SCMSourceRequest specialization. Use the constructor that takes the Class objects explicitly");
            }
            if (!SCMHeadMixin.class.isAssignableFrom(this.headClass)) {
                throw new AssertionError((Object)"Failed to correctly detect SCMHead specialization. Use the constructor that takes the Class objects explicitly");
            }
            if (!SCMRevision.class.isAssignableFrom(this.revisionClass)) {
                throw new AssertionError((Object)"Failed to correctly detect SCMRevision specialization. Use the constructor that takes the Class objects explicitly");
            }
        } else {
            throw new AssertionError((Object)"Failed to correctly detect specialization. Use the constructor that takes the Class objects explicitly");
        }
    }

    @OverrideMustInvoke
    public boolean isApplicableToHead(@NonNull SCMHead head) {
        return this.isApplicableToHead(head.getClass()) && this.isApplicableToOrigin(head.getOrigin());
    }

    @OverrideMustInvoke
    public boolean isApplicableToHead(@NonNull Class<? extends SCMHeadMixin> headClass) {
        return this.headClass.isAssignableFrom(headClass);
    }

    @OverrideMustInvoke
    public boolean isApplicableToRevision(@NonNull SCMRevision revision) {
        return this.isApplicableToHead(revision.getHead()) && this.isApplicableToRevision(revision.getClass());
    }

    @OverrideMustInvoke
    public boolean isApplicableToRevision(@NonNull Class<? extends SCMRevision> revisionClass) {
        return this.revisionClass.isAssignableFrom(revisionClass);
    }

    @OverrideMustInvoke
    public boolean isApplicableToRequest(@NonNull SCMSourceRequest request) {
        return this.requestClass.isInstance(request);
    }

    @OverrideMustInvoke
    public boolean isApplicableToRequest(@NonNull Class<? extends SCMSourceRequest> requestClass) {
        return this.requestClass.isAssignableFrom(requestClass);
    }

    public boolean isApplicableToOrigin(@NonNull SCMHeadOrigin origin) {
        return this.isApplicableToOrigin(origin.getClass());
    }

    public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
        return true;
    }
}

