/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import net.jcip.annotations.GuardedBy;
import org.jenkins.ui.icon.IconSpec;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class SCMSourceDescriptor
extends Descriptor<SCMSource>
implements IconSpec {
    @GuardedBy(value="this")
    protected transient Set<SCMHeadCategory> categories;

    @NonNull
    public String getId(@CheckForNull SCMSource source) {
        return source == null ? UUID.randomUUID().toString() : source.getId();
    }

    public boolean isApplicable(Class<? extends SCMSourceOwner> owner) {
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isUserInstantiable() {
        return true;
    }

    @NonNull
    public List<SCMSourceTrait> getTraitsDefaults() {
        return Collections.emptyList();
    }

    @NonNull
    public static List<SCMSourceDescriptor> forOwner(@CheckForNull SCMSourceOwner owner) {
        return SCMSourceDescriptor.forOwner(owner == null ? SCMSourceOwner.class : owner.getClass(), true);
    }

    @NonNull
    public static List<SCMSourceDescriptor> forOwner(@CheckForNull SCMSourceOwner owner, boolean onlyUserInstantiable) {
        return SCMSourceDescriptor.forOwner(owner == null ? SCMSourceOwner.class : owner.getClass(), onlyUserInstantiable);
    }

    @NonNull
    public static List<SCMSourceDescriptor> forOwner(Class<? extends SCMSourceOwner> clazz) {
        return SCMSourceDescriptor.forOwner(clazz, true);
    }

    @NonNull
    public static List<SCMSourceDescriptor> forOwner(Class<? extends SCMSourceOwner> clazz, boolean onlyUserInstantiable) {
        ArrayList<SCMSourceDescriptor> result = new ArrayList<SCMSourceDescriptor>();
        for (SCMSourceDescriptor descriptor : ExtensionList.lookup(SCMSourceDescriptor.class)) {
            if (!descriptor.isApplicable(clazz) || onlyUserInstantiable && !descriptor.isUserInstantiable()) continue;
            result.add(descriptor);
        }
        return result;
    }

    public String getIconClassName() {
        return null;
    }

    @CheckForNull
    public String getPronoun() {
        return null;
    }

    @NonNull
    public final synchronized Set<SCMHeadCategory> getCategories() {
        if (this.categories == null) {
            LinkedHashSet<SCMHeadCategory> categories = new LinkedHashSet<SCMHeadCategory>();
            boolean haveDefault = false;
            for (SCMHeadCategory c : this.createCategories()) {
                if (c.isUncategorized()) {
                    if (haveDefault) continue;
                    categories.add(c);
                    haveDefault = true;
                    continue;
                }
                categories.add(c);
            }
            if (!haveDefault) {
                categories.add(UncategorizedSCMHeadCategory.DEFAULT);
            }
            this.categories = Collections.unmodifiableSet(categories);
        }
        return this.categories;
    }

    @GuardedBy(value="this")
    @NonNull
    protected SCMHeadCategory[] createCategories() {
        return new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT};
    }
}

