/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.WebApp;

public abstract class SCMFile {
    @CheckForNull
    private final SCMFile parent;
    private final String name;
    private Type type;

    protected SCMFile() {
        this.parent = null;
        this.name = "";
    }

    protected SCMFile(@NonNull SCMFile parent, String name) {
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException("Name cannot contain '/'");
        }
        this.parent = parent;
        this.name = name;
    }

    @NonNull
    public final String getName() {
        return this.name;
    }

    @NonNull
    public String getPath() {
        if (this.parent == null) {
            return "";
        }
        ArrayList<String> names = new ArrayList<String>();
        for (SCMFile ptr = this; ptr != null && !ptr.isRoot(); ptr = ptr.parent()) {
            names.add(ptr.getName());
        }
        Collections.reverse(names);
        return StringUtils.join(names, (String)"/");
    }

    public final boolean isRoot() {
        return this.parent == null;
    }

    @CheckForNull
    public SCMFile parent() {
        return this.parent;
    }

    @NonNull
    public SCMFile child(String path) {
        SCMFile parent;
        int index = path.indexOf(47);
        if (index == -1) {
            if (".".equals(path)) {
                return this;
            }
            if ("..".equals(path)) {
                SCMFile parent2 = this.parent();
                return parent2 == null ? this : parent2;
            }
            return this.newChild(path, false);
        }
        String name = path.substring(0, index);
        SCMFile next = ".".equals(name) ? this : ("..".equals(name) ? ((parent = this.parent()) == null ? this : parent) : this.newChild(name, true));
        String restOfPath = path.substring(index + 1);
        return StringUtils.isBlank((CharSequence)restOfPath) ? next : next.child(restOfPath);
    }

    @NonNull
    protected abstract SCMFile newChild(@NonNull String var1, boolean var2);

    @NonNull
    public abstract Iterable<SCMFile> children() throws IOException, InterruptedException;

    public abstract long lastModified() throws IOException, InterruptedException;

    public final boolean exists() throws IOException, InterruptedException {
        return !Type.NONEXISTENT.equals((Object)this.getType());
    }

    public final boolean isFile() throws IOException, InterruptedException {
        return Type.REGULAR_FILE.equals((Object)this.getType());
    }

    public final boolean isDirectory() throws IOException, InterruptedException {
        return Type.DIRECTORY.equals((Object)this.getType());
    }

    @NonNull
    public final Type getType() throws IOException, InterruptedException {
        return this.type != null ? this.type : (this.type = this.type());
    }

    protected final void type(@NonNull Type type) {
        this.type = type;
    }

    @NonNull
    protected abstract Type type() throws IOException, InterruptedException;

    @NonNull
    public abstract InputStream content() throws IOException, InterruptedException;

    @NonNull
    public byte[] contentAsBytes() throws IOException, InterruptedException {
        InputStream is = this.content();
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @NonNull
    public String contentAsString() throws IOException, InterruptedException {
        InputStream is = this.content();
        try {
            String string = IOUtils.toString((InputStream)is, (Charset)this.contentEncoding());
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @NonNull
    public String contentMimeType() throws IOException, InterruptedException {
        return SCMFile.getMimeType(this.getName());
    }

    public boolean isContentBinary() throws IOException, InterruptedException {
        return !this.isContentText();
    }

    public boolean isContentText() throws IOException, InterruptedException {
        return StringUtils.startsWithIgnoreCase((CharSequence)this.contentMimeType(), (CharSequence)"text/");
    }

    @NonNull
    public Charset contentEncoding() throws IOException, InterruptedException {
        return Charset.defaultCharset();
    }

    @NonNull
    private static String getMimeType(@NonNull String fileName) {
        int idx = fileName.lastIndexOf(47);
        fileName = fileName.substring(idx + 1);
        idx = fileName.lastIndexOf(92);
        fileName = fileName.substring(idx + 1);
        WebApp webApp = WebApp.getCurrent();
        Object mimeType = webApp.getServletContext().getMimeType(fileName);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        if (webApp.defaultEncodingForStaticResources.containsKey(mimeType)) {
            mimeType = (String)mimeType + ";charset=" + (String)webApp.defaultEncodingForStaticResources.get(mimeType);
        }
        return mimeType;
    }

    public static enum Type {
        NONEXISTENT,
        REGULAR_FILE,
        DIRECTORY,
        LINK,
        OTHER;

    }
}

