/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.trait.SCMNavigatorContext;
import jenkins.scm.api.trait.SCMNavigatorTrait;
import jenkins.scm.api.trait.SCMNavigatorTraitDescriptor;
import jenkins.scm.api.trait.SCMSourcePrefilter;
import jenkins.scm.impl.trait.Messages;
import jenkins.scm.impl.trait.Selection;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class RegexSCMSourceFilterTrait
extends SCMNavigatorTrait {
    @NonNull
    private final String regex;
    @CheckForNull
    private transient Pattern pattern;

    @DataBoundConstructor
    public RegexSCMSourceFilterTrait(@NonNull String regex) {
        this.pattern = Pattern.compile(regex);
        this.regex = regex;
    }

    @NonNull
    public String getRegex() {
        return this.regex;
    }

    @NonNull
    private Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.regex);
        }
        return this.pattern;
    }

    @Override
    protected void decorateContext(SCMNavigatorContext<?, ?> context) {
        context.withPrefilter(new SCMSourcePrefilter(){

            @Override
            public boolean isExcluded(@NonNull SCMNavigator source, @NonNull String projectName) {
                return !RegexSCMSourceFilterTrait.this.getPattern().matcher(projectName).matches();
            }
        });
    }

    @Symbol(value={"sourceRegexFilter"})
    @Extension
    @Selection
    public static class DescriptorImpl
    extends SCMNavigatorTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.RegexSCMSourceFilterTrait_DisplayName();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRegex(@QueryParameter String value) {
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

