/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.trait.SCMNavigatorContext;
import jenkins.scm.api.trait.SCMSourceDecorator;
import jenkins.scm.api.trait.SCMSourceFilter;
import jenkins.scm.api.trait.SCMSourcePrefilter;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.impl.NoOpProjectObserver;

public abstract class SCMNavigatorRequest
implements Closeable {
    @NonNull
    private final SCMNavigator navigator;
    @NonNull
    private final List<SCMSourceFilter> filters;
    @NonNull
    private final List<SCMSourcePrefilter> prefilters;
    @NonNull
    private final SCMSourceObserver observer;
    @CheckForNull
    private final Set<String> observerIncludes;
    @NonNull
    private final List<SCMSourceTrait> traits;
    @NonNull
    private final List<SCMSourceDecorator<?, ?>> decorators;
    @NonNull
    private final List<Closeable> managedClosables = new ArrayList<Closeable>();

    protected SCMNavigatorRequest(@NonNull SCMNavigator source, @NonNull SCMNavigatorContext<?, ?> context, @NonNull SCMSourceObserver observer) {
        this.navigator = source;
        this.filters = new ArrayList<SCMSourceFilter>(context.filters());
        this.prefilters = new ArrayList<SCMSourcePrefilter>(context.prefilters());
        this.observer = observer;
        this.observerIncludes = this.observer.getIncludes();
        this.traits = new ArrayList<SCMSourceTrait>(context.traits());
        this.decorators = new ArrayList(context.decorators());
    }

    @NonNull
    public final List<SCMSourceTrait> traits() {
        return Collections.unmodifiableList(this.traits);
    }

    @NonNull
    public final List<SCMSourceDecorator<?, ?>> decorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    private static void record(@NonNull String projectName, boolean isMatch, Witness ... witnesses) {
        if (witnesses.length > 0) {
            for (Witness witness : witnesses) {
                witness.record(projectName, isMatch);
            }
        }
    }

    public final boolean isExcluded(@NonNull String projectName) throws IOException, InterruptedException {
        if (this.observerIncludes != null && !this.observerIncludes.contains(projectName)) {
            return true;
        }
        if (!this.prefilters.isEmpty()) {
            for (SCMSourcePrefilter prefilter : this.prefilters) {
                if (!prefilter.isExcluded(this.navigator, projectName)) continue;
                return true;
            }
        }
        if (this.filters.isEmpty()) {
            return false;
        }
        for (SCMSourceFilter filter : this.filters) {
            if (!filter.isExcluded(this, projectName)) continue;
            return true;
        }
        return false;
    }

    public boolean process(@NonNull String projectName, @NonNull SourceLambda sourceFactory, @CheckForNull AttributeLambda attributeFactory, Witness ... witnesses) throws IllegalArgumentException, IOException, InterruptedException {
        return this.process(projectName, Collections.singletonList(sourceFactory), attributeFactory == null ? null : Collections.singletonList(attributeFactory), witnesses);
    }

    public boolean process(@NonNull String projectName, @NonNull List<SourceLambda> sourceFactories, @CheckForNull List<AttributeLambda> attributeFactories, Witness ... witnesses) throws IllegalArgumentException, IOException, InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.isExcluded(projectName)) {
            SCMNavigatorRequest.record(projectName, false, witnesses);
            return !this.observer.isObserving();
        }
        SCMNavigatorRequest.record(projectName, true, witnesses);
        SCMSourceObserver.ProjectObserver po = this.observer.observe(projectName);
        if (po instanceof NoOpProjectObserver) {
            return !this.observer.isObserving();
        }
        for (SourceLambda s : sourceFactories) {
            po.addSource(s.create(projectName));
        }
        if (attributeFactories != null) {
            for (AttributeLambda attributeFactory : attributeFactories) {
                for (Map.Entry<String, Object> entry : attributeFactory.create(projectName).entrySet()) {
                    po.addAttribute(entry.getKey(), entry.getValue());
                }
            }
        }
        po.complete();
        return !this.observer.isObserving();
    }

    public void manage(@CheckForNull Closeable closeable) {
        if (closeable != null) {
            this.managedClosables.add(closeable);
        }
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        for (Closeable c : this.managedClosables) {
            try {
                c.close();
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                    continue;
                }
                ioe.addSuppressed(e);
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public static interface Witness {
        public void record(@NonNull String var1, boolean var2);
    }

    public static interface AttributeLambda {
        @NonNull
        public Map<String, Object> create(@NonNull String var1) throws IOException, InterruptedException;
    }

    public static interface SourceLambda {
        @NonNull
        public SCMSource create(@NonNull String var1) throws IOException, InterruptedException;
    }
}

