/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.SCM;
import java.util.Collections;
import java.util.Map;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.impl.mock.MockSCM;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMHead;
import jenkins.scm.impl.mock.MockSCMNavigator;
import jenkins.scm.impl.mock.MockSCMRevision;
import jenkins.scm.impl.mock.MockSCMSource;

public class MockSCMHeadEvent
extends SCMHeadEvent<String> {
    private final MockSCMController controller;
    private final String repository;
    private final String head;
    private final String revision;

    @Deprecated
    public MockSCMHeadEvent(@NonNull SCMEvent.Type type, MockSCMController controller, String repository, String head, String revision) {
        super(type, (Object)head);
        this.controller = controller;
        this.repository = repository;
        this.head = head;
        this.revision = revision;
    }

    public MockSCMHeadEvent(@CheckForNull String origin, @NonNull SCMEvent.Type type, MockSCMController controller, String repository, String head, String revision) {
        super(type, (Object)head, origin);
        this.controller = controller;
        this.repository = repository;
        this.head = head;
        this.revision = revision;
    }

    public boolean isMatch(@NonNull SCMNavigator navigator) {
        return navigator instanceof MockSCMNavigator && ((MockSCMNavigator)navigator).getControllerId().equals(this.controller.getId());
    }

    @NonNull
    public String getSourceName() {
        return this.repository;
    }

    @NonNull
    public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
        if (!(source instanceof MockSCMSource)) {
            return Collections.emptyMap();
        }
        if (!((MockSCMSource)source).getControllerId().equals(this.controller.getId())) {
            return Collections.emptyMap();
        }
        if (!this.repository.equals(((MockSCMSource)source).getRepository())) {
            return Collections.emptyMap();
        }
        MockSCMHead key = new MockSCMHead(this.head);
        return Collections.singletonMap(key, this.revision != null ? new MockSCMRevision(key, this.revision) : null);
    }

    public boolean isMatch(@NonNull SCM scm) {
        if (scm instanceof MockSCM) {
            MockSCM mockSCM = (MockSCM)scm;
            return this.controller.getId().equals(mockSCM.getControllerId()) && this.repository.equals(mockSCM.getRepository()) && this.head.equals(mockSCM.getHead());
        }
        return false;
    }
}

