/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.NonNull;
import javax.servlet.http.HttpServletRequest;
import jenkins.scm.api.SCMEvent;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.experimental.theories.DataPoints;
import org.junit.experimental.theories.Theories;
import org.junit.experimental.theories.Theory;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=Theories.class)
public class SCMEventTest {
    @DataPoints
    public static SCMEvent.Type[] types() {
        return SCMEvent.Type.values();
    }

    @Test
    public void executorService() throws Exception {
        MatcherAssert.assertThat((Object)SCMEvent.executorService(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)SCMEvent.executorService().isShutdown(), (Matcher)Matchers.is((Object)false));
    }

    @Theory
    public void getType(SCMEvent.Type type) throws Exception {
        MatcherAssert.assertThat((Object)new MySCMEvent(type, new Object()).getType(), (Matcher)Matchers.is((Object)type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getTimestamp() throws Exception {
        long after;
        MySCMEvent instance;
        long before = System.currentTimeMillis();
        try {
            instance = new MySCMEvent(SCMEvent.Type.CREATED, new Object());
        }
        finally {
            after = System.currentTimeMillis();
        }
        MatcherAssert.assertThat((Object)instance.getTimestamp(), (Matcher)Matchers.allOf((Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(after)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(before))));
    }

    @Test
    public void getTimestamp2() throws Exception {
        MySCMEvent instance = new MySCMEvent(SCMEvent.Type.CREATED, 53L, new Object());
        MatcherAssert.assertThat((Object)instance.getTimestamp(), (Matcher)Matchers.is((Object)53L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getDate() throws Exception {
        long after;
        MySCMEvent instance;
        long before = System.currentTimeMillis();
        try {
            instance = new MySCMEvent(SCMEvent.Type.CREATED, new Object());
        }
        finally {
            after = System.currentTimeMillis();
        }
        MatcherAssert.assertThat((Object)instance.getDate().getTime(), (Matcher)Matchers.allOf((Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(after)), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(before))));
    }

    @Test
    public void getPayload() throws Exception {
        MatcherAssert.assertThat((Object)new MySCMEvent(SCMEvent.Type.CREATED, this).getPayload(), (Matcher)Matchers.sameInstance((Object)this));
    }

    @Test
    public void equalityContract() throws Exception {
        MySCMEvent a1 = new MySCMEvent(SCMEvent.Type.CREATED, 53L, "foo");
        MySCMEvent a2 = new MySCMEvent(SCMEvent.Type.CREATED, 53L, new String("foo"));
        MySCMEvent a3 = new MySCMEvent(SCMEvent.Type.CREATED, new Long(53L), new String("foo"));
        MySCMEvent b1 = new MySCMEvent(SCMEvent.Type.UPDATED, 53L, "foo");
        MySCMEvent c1 = new MySCMEvent(SCMEvent.Type.CREATED, 54L, "foo");
        MySCMEvent d1 = new MySCMEvent(SCMEvent.Type.CREATED, 53L, "bar");
        MatcherAssert.assertThat((Object)((Object)a1), (Matcher)Matchers.is((Object)((Object)a1)));
        MatcherAssert.assertThat((Object)a1.hashCode(), (Matcher)Matchers.is((Object)a1.hashCode()));
        MatcherAssert.assertThat((Object)((Object)a1), (Matcher)Matchers.is((Object)((Object)a2)));
        MatcherAssert.assertThat((Object)a1.hashCode(), (Matcher)Matchers.is((Object)a2.hashCode()));
        MatcherAssert.assertThat((Object)((Object)a2), (Matcher)Matchers.is((Object)((Object)a1)));
        MatcherAssert.assertThat((Object)((Object)a2), (Matcher)Matchers.is((Object)((Object)a3)));
        MatcherAssert.assertThat((Object)((Object)a1), (Matcher)Matchers.is((Object)((Object)a3)));
        MatcherAssert.assertThat((Object)((Object)a1), (Matcher)Matchers.not((Matcher)Matchers.is((Object)((Object)b1))));
        MatcherAssert.assertThat((Object)((Object)a1), (Matcher)Matchers.not((Matcher)Matchers.is((Object)((Object)c1))));
        MatcherAssert.assertThat((Object)((Object)a1), (Matcher)Matchers.not((Matcher)Matchers.is((Object)((Object)d1))));
    }

    @Test
    public void usefulToString() throws Exception {
        MatcherAssert.assertThat((Object)new MySCMEvent(SCMEvent.Type.REMOVED, 1479764915000L, "{\"name\":\"value\"}").toString(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)String.format("%tc", 1479764915000L)), (Matcher)Matchers.containsString((String)"REMOVED"), (Matcher)Matchers.containsString((String)"{\"name\":\"value\"}")));
    }

    @Test
    public void originOfNull() throws Exception {
        MatcherAssert.assertThat((Object)SCMEvent.originOf(null), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void originOfSimpleRequest() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)req.getServerName()).thenReturn((Object)"jenkins.example.com");
        Mockito.when((Object)req.getRequestURI()).thenReturn((Object)"/jenkins/notify");
        Mockito.when((Object)req.getLocalPort()).thenReturn((Object)80);
        Mockito.when((Object)req.getRemoteHost()).thenReturn((Object)"scm.example.com");
        Mockito.when((Object)req.getRemoteAddr()).thenReturn((Object)"203.0.113.1");
        MatcherAssert.assertThat((Object)SCMEvent.originOf((HttpServletRequest)req), (Matcher)Matchers.is((Object)"scm.example.com/203.0.113.1 \u21d2 http://jenkins.example.com/jenkins/notify"));
    }

    @Test
    public void originOfSimpleTLSRequest() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getScheme()).thenReturn((Object)"https");
        Mockito.when((Object)req.getServerName()).thenReturn((Object)"jenkins.example.com");
        Mockito.when((Object)req.getRequestURI()).thenReturn((Object)"/jenkins/notify");
        Mockito.when((Object)req.getLocalPort()).thenReturn((Object)443);
        Mockito.when((Object)req.getRemoteHost()).thenReturn((Object)"scm.example.com");
        Mockito.when((Object)req.getRemoteAddr()).thenReturn((Object)"203.0.113.1");
        MatcherAssert.assertThat((Object)SCMEvent.originOf((HttpServletRequest)req), (Matcher)Matchers.is((Object)"scm.example.com/203.0.113.1 \u21d2 https://jenkins.example.com/jenkins/notify"));
    }

    @Test
    public void originOfSimpleRequestNonStdPort() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)req.getServerName()).thenReturn((Object)"jenkins.example.com");
        Mockito.when((Object)req.getRequestURI()).thenReturn((Object)"/jenkins/notify");
        Mockito.when((Object)req.getLocalPort()).thenReturn((Object)8080);
        Mockito.when((Object)req.getRemoteHost()).thenReturn((Object)"scm.example.com");
        Mockito.when((Object)req.getRemoteAddr()).thenReturn((Object)"203.0.113.1");
        MatcherAssert.assertThat((Object)SCMEvent.originOf((HttpServletRequest)req), (Matcher)Matchers.is((Object)"scm.example.com/203.0.113.1 \u21d2 http://jenkins.example.com:8080/jenkins/notify"));
    }

    @Test
    public void originOfSimpleTLSRequestNonStdPort() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getScheme()).thenReturn((Object)"https");
        Mockito.when((Object)req.getServerName()).thenReturn((Object)"jenkins.example.com");
        Mockito.when((Object)req.getRequestURI()).thenReturn((Object)"/jenkins/notify");
        Mockito.when((Object)req.getLocalPort()).thenReturn((Object)8443);
        Mockito.when((Object)req.getRemoteHost()).thenReturn((Object)"scm.example.com");
        Mockito.when((Object)req.getRemoteAddr()).thenReturn((Object)"203.0.113.1");
        MatcherAssert.assertThat((Object)SCMEvent.originOf((HttpServletRequest)req), (Matcher)Matchers.is((Object)"scm.example.com/203.0.113.1 \u21d2 https://jenkins.example.com:8443/jenkins/notify"));
    }

    @Test
    public void originOfForwardedRequestSingleHop() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)req.getServerName()).thenReturn((Object)"jenkins.example.com");
        Mockito.when((Object)req.getHeader("X-Forwarded-Proto")).thenReturn((Object)"https");
        Mockito.when((Object)req.getHeader("X-Forwarded-Port")).thenReturn((Object)"443");
        Mockito.when((Object)req.getHeader("X-Forwarded-For")).thenReturn((Object)"scm.example.com");
        Mockito.when((Object)req.getRequestURI()).thenReturn((Object)"/jenkins/notify");
        Mockito.when((Object)req.getLocalPort()).thenReturn((Object)8080);
        Mockito.when((Object)req.getRemoteHost()).thenReturn((Object)"proxy.example.com");
        Mockito.when((Object)req.getRemoteAddr()).thenReturn((Object)"203.0.113.1");
        MatcherAssert.assertThat((Object)SCMEvent.originOf((HttpServletRequest)req), (Matcher)Matchers.is((Object)"scm.example.com \u2192 proxy.example.com/203.0.113.1 \u21d2 https://jenkins.example.com/jenkins/notify"));
    }

    @Test
    public void originOfForwardedRequestMultiHop() throws Exception {
        HttpServletRequest req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)req.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)req.getServerName()).thenReturn((Object)"jenkins.example.com");
        Mockito.when((Object)req.getHeader("X-Forwarded-Proto")).thenReturn((Object)"https");
        Mockito.when((Object)req.getHeader("X-Forwarded-Port")).thenReturn((Object)"443");
        Mockito.when((Object)req.getHeader("X-Forwarded-For")).thenReturn((Object)"scm.example.com, gateway.example.com, proxy.example.com");
        Mockito.when((Object)req.getRequestURI()).thenReturn((Object)"/jenkins/notify");
        Mockito.when((Object)req.getRemotePort()).thenReturn((Object)8080);
        Mockito.when((Object)req.getRemoteHost()).thenReturn(null);
        Mockito.when((Object)req.getRemoteAddr()).thenReturn((Object)"203.0.113.1");
        MatcherAssert.assertThat((Object)SCMEvent.originOf((HttpServletRequest)req), (Matcher)Matchers.is((Object)"scm.example.com \u2192 gateway.example.com \u2192 proxy.example.com \u2192 203.0.113.1 \u21d2 https://jenkins.example.com/jenkins/notify"));
    }

    public static class MySCMEvent
    extends SCMEvent<Object> {
        private final Long widget;

        public MySCMEvent(@NonNull SCMEvent.Type type, long timestamp, @NonNull Object payload) {
            super(type, timestamp, payload);
            this.widget = 1L;
        }

        public MySCMEvent(@NonNull SCMEvent.Type type, @NonNull Object payload) {
            super(type, payload);
            this.widget = 1L;
        }

        protected MySCMEvent(MySCMEvent copy) {
            super((SCMEvent)copy);
            this.widget = copy.widget == null ? 0L : copy.widget;
        }

        private Object readResolve() {
            if (this.widget == null) {
                return new MySCMEvent(this);
            }
            return this;
        }
    }
}

