/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class SCMHeadObserverTest {
    @Test
    public void allOf() throws Exception {
        SCMHead head1 = new SCMHead("bar");
        SCMRevision revision1 = (SCMRevision)Mockito.mock(SCMRevision.class);
        SCMHead head2 = new SCMHead("foo");
        SCMRevision revision2 = (SCMRevision)Mockito.mock(SCMRevision.class);
        SCMHeadObserver.AllFinished instance = SCMHeadObserver.allOf((SCMHeadObserver[])new SCMHeadObserver[]{SCMHeadObserver.select((SCMHead)head2), SCMHeadObserver.select((SCMHead)head1)});
        Assert.assertThat((String)"Observing from the start", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((String)"Wants everything", (Object)instance.getIncludes(), (Matcher)Matchers.containsInAnyOrder((Object[])new SCMHead[]{head1, head2}));
        instance.observe(head1, revision1);
        Assert.assertThat((String)"Stops when all of the observers have stopped", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        instance.observe(head2, revision2);
        Assert.assertThat((String)"Stops when all of the observers have stopped", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void first() throws Exception {
        SCMHeadObserver.OneFinished instance = SCMHeadObserver.first((SCMHeadObserver[])new SCMHeadObserver[]{SCMHeadObserver.collect(), SCMHeadObserver.any()});
        SCMHead head1 = new SCMHead("bar");
        SCMRevision revision1 = (SCMRevision)Mockito.mock(SCMRevision.class);
        Assert.assertThat((String)"Observing from the start", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((String)"Wants everything", (Object)instance.getIncludes(), (Matcher)Matchers.nullValue());
        instance.observe(head1, revision1);
        Assert.assertThat((String)"Stops when one of the observers has stopped", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void collect() throws Exception {
        SCMHead head1 = new SCMHead("bar");
        SCMRevision revision1 = (SCMRevision)Mockito.mock(SCMRevision.class);
        SCMHead head2 = new SCMHead("foo");
        SCMRevision revision2 = (SCMRevision)Mockito.mock(SCMRevision.class);
        SCMHeadObserver.Collector instance = SCMHeadObserver.collect();
        Assert.assertThat((String)"Observing from the start", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((String)"Wants everything", (Object)instance.getIncludes(), (Matcher)Matchers.nullValue());
        instance.observe(head1, revision1);
        Assert.assertThat((String)"Still observing", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        instance.observe(head2, revision2);
        Assert.assertThat((String)"Still observing", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)instance.result(), (Matcher)Matchers.allOf((Matcher)Matchers.hasEntry((Object)head1, (Object)revision1), (Matcher)Matchers.hasEntry((Object)head2, (Object)revision2)));
    }

    @Test
    public void select() throws Exception {
        SCMHead head1 = new SCMHead("bar");
        SCMRevision revision1 = (SCMRevision)Mockito.mock(SCMRevision.class);
        SCMHead head2 = new SCMHead("foo");
        SCMRevision revision2 = (SCMRevision)Mockito.mock(SCMRevision.class);
        SCMHeadObserver.Selector instance = SCMHeadObserver.select((SCMHead)head2);
        Assert.assertThat((String)"Observing from the start", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((String)"Wants only selected head", (Object)instance.getIncludes(), (Matcher)Matchers.contains((Object[])new SCMHead[]{head2}));
        instance.observe(head1, revision1);
        Assert.assertThat((String)"Still observing before match", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        instance.observe(head2, revision2);
        Assert.assertThat((String)"Stops observing after selected observation", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)instance.result(), (Matcher)Matchers.is((Object)revision2));
    }

    @Test
    public void filter() throws Exception {
        SCMHead head1 = new SCMHead("bar");
        SCMRevision revision1 = (SCMRevision)Mockito.mock(SCMRevision.class);
        SCMHead head2 = new SCMHead("foo");
        SCMRevision revision2 = (SCMRevision)Mockito.mock(SCMRevision.class);
        SCMHeadObserver.Filter instance = SCMHeadObserver.filter((SCMHeadObserver)SCMHeadObserver.collect(), (SCMHead[])new SCMHead[]{head2});
        Assert.assertThat((String)"Observing from the start", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((String)"Wants only selected head", (Object)instance.getIncludes(), (Matcher)Matchers.contains((Object[])new SCMHead[]{head2}));
        instance.observe(head1, revision1);
        Assert.assertThat((String)"Still observing before match", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        instance.observe(head2, revision2);
        Assert.assertThat((String)"Stops observing after selected observation", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)((SCMHeadObserver.Collector)instance.unwrap()).result(), (Matcher)Matchers.hasEntry((Object)head2, (Object)revision2));
        Assert.assertThat((Object)((SCMHeadObserver.Collector)instance.unwrap()).result(), (Matcher)Matchers.not((Matcher)Matchers.hasKey((Object)head1)));
    }

    @Test
    public void named() throws Exception {
        SCMHeadObserver.Named instance = SCMHeadObserver.named((String)"foo");
        Assert.assertThat((String)"Observing from the start", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((String)"Wants everything", (Object)instance.getIncludes(), (Matcher)Matchers.nullValue());
        SCMHead head1 = (SCMHead)Mockito.mock(SCMHead.class);
        SCMRevision revision1 = (SCMRevision)Mockito.mock(SCMRevision.class);
        SCMHead head2 = (SCMHead)Mockito.mock(SCMHead.class);
        SCMRevision revision2 = (SCMRevision)Mockito.mock(SCMRevision.class);
        Mockito.when((Object)head1.getName()).thenReturn((Object)"bar");
        Mockito.when((Object)head2.getName()).thenReturn((Object)"foo");
        instance.observe(head1, revision1);
        Assert.assertThat((String)"Still observing before match", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        instance.observe(head2, revision2);
        Assert.assertThat((String)"Stops observing after matching observation", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)instance.result(), (Matcher)Matchers.is((Object)revision2));
    }

    @Test
    public void any() throws Exception {
        SCMHeadObserver.Any instance = SCMHeadObserver.any();
        Assert.assertThat((String)"Observing from the start", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((String)"Wants everything", (Object)instance.getIncludes(), (Matcher)Matchers.nullValue());
        SCMHead head = (SCMHead)Mockito.mock(SCMHead.class);
        SCMRevision revision = (SCMRevision)Mockito.mock(SCMRevision.class);
        instance.observe(head, revision);
        Assert.assertThat((String)"Stops observing after first observation", (Object)instance.isObserving(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)instance.result(), (Matcher)Matchers.is((Object)revision));
    }
}

