/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Action;
import hudson.model.Item;
import hudson.util.AlternativeUiTextProvider;
import java.util.Collections;
import java.util.List;
import jenkins.scm.api.SCMHeadMixinEqualityGenerator;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.mixin.SCMHeadMixin;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SCMHead
implements SCMHeadMixin {
    public static final AlternativeUiTextProvider.Message<SCMHead> PRONOUN = new AlternativeUiTextProvider.Message();
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String name;

    public SCMHead(@NonNull String name) {
        name.getClass();
        this.name = name;
    }

    @Override
    @Exported
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @Exported
    @NonNull
    public SCMHeadOrigin getOrigin() {
        return SCMHeadOrigin.DEFAULT;
    }

    @CheckForNull
    public String getPronoun() {
        return AlternativeUiTextProvider.get(PRONOUN, (Object)this, null);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SCMHead scmHead = (SCMHead)o;
        if (!this.name.equals(scmHead.name)) {
            return false;
        }
        return SCMHeadMixinEqualityGenerator.getOrCreate(this.getClass()).equals(this, scmHead);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(SCMHead o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        return "SCMHead{'" + this.name + "'}";
    }

    @Restricted(value={DoNotUse.class})
    @Deprecated
    @NonNull
    public List<? extends Action> getAllActions() {
        return Collections.emptyList();
    }

    @Restricted(value={DoNotUse.class})
    @Deprecated
    @CheckForNull
    public <T extends Action> T getAction(@NonNull Class<T> type) {
        return null;
    }

    public static abstract class HeadByItem
    implements ExtensionPoint {
        @CheckForNull
        public abstract SCMHead getHead(Item var1);

        @CheckForNull
        public static SCMHead findHead(Item item) {
            for (HeadByItem ext : ExtensionList.lookup(HeadByItem.class)) {
                SCMHead head = ext.getHead(item);
                if (head == null) continue;
                return head;
            }
            return null;
        }
    }
}

