/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.RestrictedSince;
import hudson.model.Actionable;
import hudson.model.InvisibleAction;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SCMRevisionAction
extends InvisibleAction {
    @CheckForNull
    private final String sourceId;
    @NonNull
    private final SCMRevision revision;

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    public SCMRevisionAction(@NonNull SCMRevision revision) {
        this(revision, null);
    }

    public SCMRevisionAction(@NonNull SCMSource source, @NonNull SCMRevision revision) {
        this(revision, source.getId());
    }

    SCMRevisionAction(@NonNull SCMRevision revision, @CheckForNull String sourceId) {
        revision.getClass();
        this.sourceId = sourceId;
        this.revision = revision;
    }

    @Exported
    @NonNull
    public SCMRevision getRevision() {
        return this.revision;
    }

    @CheckForNull
    public String getSourceId() {
        return this.sourceId;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.2.0")
    @CheckForNull
    public static SCMRevision getRevision(@NonNull Actionable actionable) {
        SCMRevisionAction action = (SCMRevisionAction)actionable.getAction(SCMRevisionAction.class);
        return action != null ? action.getRevision() : null;
    }

    @CheckForNull
    public static SCMRevision getRevision(@NonNull SCMSource source, @NonNull Actionable actionable) {
        String sourceId = source.getId();
        SCMRevisionAction fallback = null;
        for (SCMRevisionAction a : actionable.getActions(SCMRevisionAction.class)) {
            if (sourceId.equals(a.getSourceId())) {
                return a.getRevision();
            }
            if (a.getSourceId() != null || fallback != null) continue;
            fallback = a;
        }
        return fallback == null ? null : fallback.getRevision();
    }
}

