/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMHeadFilter;
import jenkins.scm.api.trait.SCMHeadPrefilter;
import jenkins.scm.api.trait.SCMSourceContext;

public abstract class SCMSourceRequest
implements Closeable {
    @NonNull
    private final SCMSource source;
    @NonNull
    private final List<SCMHeadFilter> filters;
    @NonNull
    private final List<SCMHeadPrefilter> prefilters;
    @NonNull
    private final List<SCMHeadAuthority> authorities;
    @NonNull
    private final List<SCMSourceCriteria> criteria;
    @NonNull
    private final TaskListener listener;
    @NonNull
    private final SCMHeadObserver observer;
    @CheckForNull
    private final Set<SCMHead> observerIncludes;
    @NonNull
    private final List<Closeable> managedClosables = new ArrayList<Closeable>();

    protected SCMSourceRequest(@NonNull SCMSource source, @NonNull SCMSourceContext<?, ?> context, @CheckForNull TaskListener listener) {
        this.source = source;
        this.filters = Collections.unmodifiableList(new ArrayList<SCMHeadFilter>(context.filters()));
        this.prefilters = Collections.unmodifiableList(new ArrayList<SCMHeadPrefilter>(context.prefilters()));
        this.authorities = Collections.unmodifiableList(new ArrayList(context.authorities()));
        this.criteria = context.criteria().isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<SCMSourceCriteria>(context.criteria()));
        this.observer = context.observer();
        this.observerIncludes = this.observer.getIncludes();
        this.listener = this.defaultListener(listener);
    }

    private static void record(@NonNull SCMHead head, SCMRevision revision, boolean isMatch, Witness ... witnesses) {
        for (Witness witness : witnesses) {
            witness.record(head, revision, isMatch);
        }
    }

    @NonNull
    private TaskListener defaultListener(@CheckForNull TaskListener listener) {
        if (listener == null) {
            Level level;
            try {
                level = Level.parse(System.getProperty(this.getClass().getName() + ".defaultListenerLevel", "FINE"));
            }
            catch (IllegalArgumentException e) {
                level = Level.FINE;
            }
            return new LogTaskListener(Logger.getLogger(this.getClass().getName()), level);
        }
        return listener;
    }

    public final boolean isExcluded(@NonNull SCMHead head) throws IOException, InterruptedException {
        if (this.observerIncludes != null && !this.observerIncludes.contains(head)) {
            return true;
        }
        if (!this.prefilters.isEmpty()) {
            for (SCMHeadPrefilter prefilter : this.prefilters) {
                if (!prefilter.isExcluded(this.source, head)) continue;
                return true;
            }
        }
        if (this.filters.isEmpty()) {
            return false;
        }
        for (SCMHeadFilter filter : this.filters) {
            if (!filter.isExcluded(this, head)) continue;
            return true;
        }
        return false;
    }

    public final boolean isTrusted(@NonNull SCMHead head) throws IOException, InterruptedException {
        for (SCMHeadAuthority authority : this.authorities) {
            if (!authority.isTrusted(this, head)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public final List<SCMSourceCriteria> getCriteria() {
        return this.criteria;
    }

    public final <H extends SCMHead, R extends SCMRevision> boolean process(@NonNull H head, final @NonNull R revision, @NonNull ProbeLambda<H, R> probeFactory, Witness ... witnesses) throws IOException, InterruptedException {
        return this.process(head, new IntermediateLambda<R>(){

            @Override
            @Nullable
            public R create() throws IOException, InterruptedException {
                return revision;
            }
        }, probeFactory, new LazyRevisionLambda<H, SCMRevision, R>(){

            @Override
            @NonNull
            public SCMRevision create(@NonNull H head, @Nullable R ignored) throws IOException, InterruptedException {
                return revision;
            }
        }, witnesses);
    }

    public final <H extends SCMHead, R extends SCMRevision> boolean process(final @NonNull H head, final @NonNull RevisionLambda<H, R> revisionFactory, @NonNull ProbeLambda<H, R> probeFactory, Witness ... witnesses) throws IOException, InterruptedException {
        return this.process(head, new IntermediateLambda<R>(){

            @Override
            @NonNull
            public R create() throws IOException, InterruptedException {
                return revisionFactory.create(head);
            }
        }, probeFactory, new LazyRevisionLambda<H, SCMRevision, R>(){

            @Override
            @NonNull
            public SCMRevision create(@NonNull H head, @Nullable R revision) throws IOException, InterruptedException {
                assert (revision != null);
                return revision;
            }
        }, witnesses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <H extends SCMHead, I, R extends SCMRevision> boolean process(@NonNull H head, @CheckForNull IntermediateLambda<I> intermediateFactory, @NonNull ProbeLambda<H, I> probeFactory, @NonNull LazyRevisionLambda<H, R, I> revisionFactory, Witness ... witnesses) throws IOException, InterruptedException {
        Object intermediate;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.isExcluded(head)) {
            return !this.observer.isObserving();
        }
        Object i = intermediate = intermediateFactory == null ? null : (Object)intermediateFactory.create();
        if (!this.criteria.isEmpty()) {
            SCMSourceCriteria.Probe probe = probeFactory.create(head, intermediate);
            try {
                for (SCMSourceCriteria c : this.criteria) {
                    if (c.isHead(probe, this.listener)) continue;
                    SCMSourceRequest.record(head, null, false, witnesses);
                    boolean bl = !this.observer.isObserving();
                    return bl;
                }
            }
            finally {
                if (probe instanceof Closeable) {
                    ((Closeable)((Object)probe)).close();
                }
            }
        }
        R revision = revisionFactory.create(head, intermediate);
        SCMSourceRequest.record(head, revision, true, witnesses);
        this.observer.observe(head, (SCMRevision)revision);
        return !this.observer.isObserving();
    }

    public boolean isComplete() {
        return !this.observer.isObserving();
    }

    @NonNull
    public TaskListener listener() {
        return this.listener;
    }

    public void manage(@CheckForNull Closeable closeable) {
        if (closeable != null) {
            this.managedClosables.add(closeable);
        }
    }

    @Override
    public void close() throws IOException {
        IOException ioe = null;
        for (Closeable c : this.managedClosables) {
            try {
                c.close();
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                    continue;
                }
                try {
                    Method addSuppressed = Throwable.class.getMethod("addSuppressed", Throwable.class);
                    addSuppressed.invoke((Object)ioe, e);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    public static interface Witness<H extends SCMHead, R extends SCMRevision> {
        public void record(@NonNull H var1, @CheckForNull R var2, boolean var3);
    }

    public static interface LazyRevisionLambda<H extends SCMHead, R extends SCMRevision, I> {
        @NonNull
        public R create(@NonNull H var1, @Nullable I var2) throws IOException, InterruptedException;
    }

    public static interface IntermediateLambda<I> {
        @Nullable
        public I create() throws IOException, InterruptedException;
    }

    public static interface ProbeLambda<H extends SCMHead, I> {
        @NonNull
        public SCMSourceCriteria.Probe create(@NonNull H var1, @Nullable I var2) throws IOException, InterruptedException;
    }

    public static interface RevisionLambda<H extends SCMHead, R extends SCMRevision> {
        @NonNull
        public R create(@NonNull H var1) throws IOException, InterruptedException;
    }
}

