/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.trait;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.trait.SCMNavigatorRequest;
import jenkins.scm.api.trait.SCMNavigatorTrait;
import jenkins.scm.api.trait.SCMSourceDecorator;
import jenkins.scm.api.trait.SCMSourceFilter;
import jenkins.scm.api.trait.SCMSourcePrefilter;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMTrait;

public abstract class SCMNavigatorContext<C extends SCMNavigatorContext<C, R>, R extends SCMNavigatorRequest> {
    @NonNull
    private final List<SCMSourcePrefilter> prefilters = new ArrayList<SCMSourcePrefilter>();
    @NonNull
    private final List<SCMSourceFilter> filters = new ArrayList<SCMSourceFilter>();
    @NonNull
    private final List<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();
    @NonNull
    private final List<SCMSourceDecorator<?, ?>> decorators = new ArrayList();

    @NonNull
    public final List<SCMSourceDecorator<?, ?>> decorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    @NonNull
    public final List<SCMSourceFilter> filters() {
        return Collections.unmodifiableList(this.filters);
    }

    @NonNull
    public final List<SCMSourcePrefilter> prefilters() {
        return Collections.unmodifiableList(this.prefilters);
    }

    @NonNull
    public final List<SCMSourceTrait> traits() {
        return Collections.unmodifiableList(this.traits);
    }

    @NonNull
    public final C withFilter(@CheckForNull SCMSourceFilter filter) {
        if (filter != null) {
            this.filters.add(filter);
        }
        return (C)this;
    }

    @NonNull
    public final C withPrefilter(@CheckForNull SCMSourcePrefilter prefilter) {
        if (prefilter != null) {
            this.prefilters.add(prefilter);
        }
        return (C)this;
    }

    @NonNull
    public final C withTrait(@NonNull SCMNavigatorTrait trait) {
        trait.applyToContext(this);
        return (C)this;
    }

    @NonNull
    public final C withTrait(@NonNull SCMSourceTrait trait) {
        this.traits.add(trait);
        return (C)this;
    }

    @NonNull
    public final C withTraits(SCMTrait<? extends SCMTrait<?>> ... traits) {
        return this.withTraits(Arrays.asList(traits));
    }

    @NonNull
    public final C withTraits(@NonNull Collection<? extends SCMTrait<?>> traits) {
        for (SCMTrait<?> trait : traits) {
            if (trait instanceof SCMNavigatorTrait) {
                this.withTrait((SCMNavigatorTrait)trait);
                continue;
            }
            if (trait instanceof SCMSourceTrait) {
                this.withTrait((SCMSourceTrait)trait);
                continue;
            }
            throw new IllegalArgumentException("Unsupported trait: " + ((Object)trait).getClass().getName());
        }
        return (C)this;
    }

    @NonNull
    public final C withDecorator(@NonNull SCMSourceDecorator<?, ?> decorator) {
        this.decorators.add(decorator);
        return (C)this;
    }

    @NonNull
    public final C withDecorators(SCMSourceDecorator<?, ?> ... decorators) {
        return this.withDecorators(Arrays.asList(decorators));
    }

    @NonNull
    public final C withDecorators(@NonNull Collection<? extends SCMSourceDecorator<?, ?>> decorators) {
        this.decorators.addAll(decorators);
        return (C)this;
    }

    @NonNull
    public abstract R newRequest(@NonNull SCMNavigator var1, @NonNull SCMSourceObserver var2);
}

