/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.mixin;

import edu.umd.cs.findbugs.annotations.NonNull;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import org.kohsuke.stapler.export.Exported;

public abstract class ChangeRequestSCMRevision<H extends SCMHead>
extends SCMRevision {
    private final SCMRevision target;

    protected ChangeRequestSCMRevision(@NonNull H head, @NonNull SCMRevision target) {
        super((SCMHead)head);
        if (!target.getHead().equals(((ChangeRequestSCMHead)head).getTarget())) {
            throw new IllegalArgumentException("The target revision's head must correspond to the heads target");
        }
        this.target = target;
    }

    @Exported
    @NonNull
    public final SCMRevision getTarget() {
        return this.target;
    }

    public final boolean isMerge() {
        SCMHead head = this.getHead();
        return !(head instanceof ChangeRequestSCMHead2) || ((ChangeRequestSCMHead2)((Object)head)).getCheckoutStrategy() != ChangeRequestCheckoutStrategy.HEAD;
    }

    public abstract boolean equivalent(ChangeRequestSCMRevision<?> var1);

    protected abstract int _hashCode();

    @Override
    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeRequestSCMRevision that = (ChangeRequestSCMRevision)o;
        if (!this.equivalent(that)) {
            return false;
        }
        if (this.isMerge() && that.isMerge()) {
            return this.target.equals(that.target);
        }
        return this.isMerge() == that.isMerge();
    }

    @Override
    public final int hashCode() {
        int rv = this._hashCode();
        if (this.isMerge()) {
            rv = rv * 31 + this.target.hashCode();
        }
        return rv;
    }
}

