/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.SCM;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMEventListener;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;

public abstract class SCMHeadEvent<P>
extends SCMEvent<P> {
    private static final Logger LOGGER = Logger.getLogger(SCMHeadEvent.class.getName());

    @Deprecated
    public SCMHeadEvent(@NonNull SCMEvent.Type type, long timestamp, @NonNull P payload) {
        super(type, timestamp, payload);
    }

    public SCMHeadEvent(@NonNull SCMEvent.Type type, long timestamp, @NonNull P payload, @CheckForNull String origin) {
        super(type, timestamp, payload, origin);
    }

    @Deprecated
    public SCMHeadEvent(@NonNull SCMEvent.Type type, @NonNull P payload) {
        super(type, payload);
    }

    public SCMHeadEvent(@NonNull SCMEvent.Type type, @NonNull P payload, @CheckForNull String origin) {
        super(type, payload, origin);
    }

    protected SCMHeadEvent(@NonNull SCMHeadEvent<P> src) {
        super(src);
    }

    public abstract boolean isMatch(@NonNull SCMNavigator var1);

    @NonNull
    public abstract String getSourceName();

    public boolean isMatch(@NonNull SCMSource source) {
        return !this.heads(source).isEmpty();
    }

    @NonNull
    public abstract Map<SCMHead, SCMRevision> heads(@NonNull SCMSource var1);

    public abstract boolean isMatch(@NonNull SCM var1);

    public <O extends SCMHeadObserver> SCMHeadObserver.Wrapped<O> filter(@NonNull SCMSource source, O delegate) {
        return new Validated(this, delegate, source);
    }

    public static void fireNow(@NonNull SCMHeadEvent<?> event) {
        SCMHeadEvent.executorService().execute(new DispatcherImpl(event));
    }

    public static void fireLater(@NonNull SCMHeadEvent<?> event, long delay, TimeUnit delayUnits) {
        SCMHeadEvent.executorService().schedule(new DispatcherImpl(event), delay, delayUnits);
    }

    private static class Validated<O extends SCMHeadObserver>
    extends SCMHeadObserver.Wrapped<O> {
        private final Set<SCMHead> includes;
        private final Map<SCMHead, SCMRevision> untrusted;
        private final Map<SCMHead, SCMRevision> trusted;
        final /* synthetic */ SCMHeadEvent this$0;

        private Validated(O delegate, SCMSource source) {
            this.this$0 = var1_1;
            super(delegate);
            this.untrusted = new HashMap<SCMHead, SCMRevision>(var1_1.heads(source));
            Set<SCMHead> i = super.getIncludes();
            if (i != null) {
                this.untrusted.keySet().retainAll(i);
            }
            this.includes = new HashSet<SCMHead>(this.untrusted.keySet());
            this.trusted = new HashMap<SCMHead, SCMRevision>(this.untrusted.size());
        }

        @Override
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) throws IOException, InterruptedException {
            if (this.untrusted.containsKey(head)) {
                this.trusted.put(head, revision);
                this.untrusted.remove(head);
                super.observe(head, revision);
            }
        }

        @Override
        public boolean isObserving() {
            return !this.untrusted.isEmpty() && super.isObserving();
        }

        public Map<SCMHead, SCMRevision> heads() {
            return this.trusted;
        }

        @Override
        public Set<SCMHead> getIncludes() {
            return this.includes;
        }
    }

    private static class DispatcherImpl
    extends SCMEvent.Dispatcher<SCMHeadEvent<?>> {
        private DispatcherImpl(SCMHeadEvent<?> event) {
            super(event);
        }

        @Override
        protected void log(SCMEventListener l, Throwable e) {
            LogRecord lr = new LogRecord(Level.WARNING, "SCMEventListener.onSCMHeadEvent(SCMHeadEvent) {0} propagated an exception");
            lr.setThrown(e);
            lr.setParameters(new Object[]{l});
            LOGGER.log(lr);
        }

        @Override
        protected void fire(SCMEventListener l, SCMHeadEvent<?> event) {
            l.onSCMHeadEvent(event);
        }
    }
}

