/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import jenkins.scm.api.Messages;
import org.apache.commons.lang.StringUtils;
import org.jvnet.localizer.Localizable;

public abstract class SCMCategory<T> {
    private final String name;
    @CheckForNull
    private final Localizable displayName;
    private final boolean uncategorized;

    public SCMCategory(@CheckForNull Localizable displayName) {
        this.displayName = displayName;
        this.uncategorized = true;
        this.name = "default";
    }

    public SCMCategory(@NonNull String name, @CheckForNull Localizable displayName) {
        if ("default".equals(name)) {
            throw new IllegalArgumentException("Use the SCMCategory(Localizable) constructor to create an uncategorized category");
        }
        this.displayName = displayName;
        this.uncategorized = false;
        this.name = name;
    }

    @NonNull
    public static <C extends SCMCategory<?>> Localizable toDisplayName(C ... categories) {
        return SCMCategory.toDisplayName(Arrays.asList(categories));
    }

    @NonNull
    public static <C extends SCMCategory<?>> Localizable toDisplayName(@NonNull List<C> categories) {
        if (categories.isEmpty()) {
            throw new IllegalArgumentException("Must supply at least one category");
        }
        if (categories.size() == 1) {
            return ((SCMCategory)categories.get(0)).getDisplayName();
        }
        ArrayList<Localizable> localizables = new ArrayList<Localizable>(categories.size());
        for (SCMCategory category : categories) {
            localizables.add(category.getDisplayName());
        }
        return new CompositeLocalizable(localizables);
    }

    @NonNull
    public static <C extends SCMCategory<?>> String toShortUrl(C ... categories) {
        return SCMCategory.toShortUrl(Arrays.asList(categories));
    }

    @NonNull
    public static <C extends SCMCategory<?>> String toShortUrl(List<C> categories) {
        if (categories.isEmpty()) {
            throw new IllegalArgumentException("Must supply at least one category");
        }
        if (categories.size() == 1) {
            return ((SCMCategory)categories.get(0)).getName().toLowerCase(Locale.ENGLISH);
        }
        TreeSet<String> urlNames = new TreeSet<String>();
        for (SCMCategory category : categories) {
            urlNames.add(category.getName().toLowerCase(Locale.ENGLISH));
        }
        return StringUtils.join(urlNames, (String)"_");
    }

    @NonNull
    public static <T, C extends SCMCategory<T>> Map<String, List<C>> group(C ... categories) {
        return SCMCategory.group(Arrays.asList(categories));
    }

    @NonNull
    public static <T, C extends SCMCategory<T>> Map<String, List<C>> group(@NonNull Iterable<C> categories) {
        TreeMap<String, List<C>> result = new TreeMap<String, List<C>>();
        for (SCMCategory c : categories) {
            String name = c.getName();
            ArrayList<SCMCategory> l = (ArrayList<SCMCategory>)result.get(name);
            if (l == null) {
                l = new ArrayList<SCMCategory>();
                result.put(name, l);
            }
            l.add(c);
        }
        return result;
    }

    @NonNull
    public final String getName() {
        return this.name;
    }

    @NonNull
    public Localizable getDisplayName() {
        return this.displayName == null ? this.defaultDisplayName() : this.displayName;
    }

    @NonNull
    protected abstract Localizable defaultDisplayName();

    public final boolean isUncategorized() {
        return this.uncategorized;
    }

    public abstract boolean isMatch(@NonNull T var1);

    public boolean isMatch(@NonNull T instance, @Nullable Iterable<? extends SCMCategory<T>> categories) {
        if (this.isUncategorized()) {
            if (categories != null) {
                for (SCMCategory<T> category : categories) {
                    if (category.isUncategorized() || !category.isMatch(instance)) continue;
                    return false;
                }
            }
            return true;
        }
        return this.isMatch(instance);
    }

    private static class LocalizableComparator
    implements Comparator<Localizable>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Locale locale;

        public LocalizableComparator(Locale locale) {
            this.locale = locale;
        }

        @Override
        public int compare(Localizable o1, Localizable o2) {
            return o1.toString(this.locale).compareTo(o2.toString(this.locale));
        }
    }

    private static class CompositeLocalizable
    extends Localizable {
        private static final long serialVersionUID = 1L;
        private final List<Localizable> terms;

        public CompositeLocalizable(List<Localizable> terms) {
            super(null, null, new Object[0]);
            if (terms.size() < 2) {
                throw new IllegalArgumentException("Must have at least two Localizable instances to join");
            }
            this.terms = terms;
        }

        public String toString(Locale locale) {
            TreeSet<Localizable> pronouns = new TreeSet<Localizable>(new LocalizableComparator(locale));
            pronouns.addAll(this.terms);
            Iterator iterator = pronouns.iterator();
            Localizable result = (Localizable)iterator.next();
            while (iterator.hasNext()) {
                Localizable next = (Localizable)iterator.next();
                result = Messages._SCMCategory_Join(result, next);
            }
            return result.toString();
        }
    }
}

