/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import net.jcip.annotations.GuardedBy;

public abstract class SCMHeadObserver {
    public abstract void observe(@NonNull SCMHead var1, @NonNull SCMRevision var2);

    public boolean isObserving() {
        return true;
    }

    @CheckForNull
    public Set<SCMHead> getIncludes() {
        return null;
    }

    @NonNull
    public static AllFinished allOf(SCMHeadObserver ... observers) {
        return new AllFinished(observers);
    }

    @NonNull
    public static OneFinished first(SCMHeadObserver ... observers) {
        return new OneFinished(observers);
    }

    @NonNull
    public static Collector collect() {
        return new Collector();
    }

    @NonNull
    public static Selector select(@NonNull SCMHead head) {
        return new Selector(head);
    }

    @NonNull
    public static <O extends SCMHeadObserver> Filter<O> filter(O delegate, SCMHead ... heads) {
        return new Filter<O>(delegate, heads);
    }

    @NonNull
    public static Named named(@NonNull String headName) {
        return new Named(headName);
    }

    @NonNull
    public static Any any() {
        return new Any();
    }

    public static class Filter<O extends SCMHeadObserver>
    extends Wrapped<O> {
        private final Set<SCMHead> heads;
        private final Set<SCMHead> remaining;

        public Filter(O delegate, SCMHead ... heads) {
            super(delegate);
            this.heads = new HashSet<SCMHead>(Arrays.asList(heads));
            Set<SCMHead> includes = super.getIncludes();
            if (includes != null) {
                this.heads.retainAll(includes);
            }
            this.remaining = new HashSet<SCMHead>(this.heads);
        }

        @Override
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            if (this.remaining.contains(head)) {
                this.remaining.remove(head);
                super.observe(head, revision);
            }
        }

        @Override
        public boolean isObserving() {
            return !this.remaining.isEmpty() && super.isObserving();
        }

        @Override
        public Set<SCMHead> getIncludes() {
            return this.heads;
        }
    }

    public static abstract class Wrapped<O extends SCMHeadObserver>
    extends SCMHeadObserver {
        private final O delegate;

        protected Wrapped(O delegate) {
            this.delegate = delegate;
        }

        public O unwrap() {
            return this.delegate;
        }

        @Override
        public boolean isObserving() {
            return ((SCMHeadObserver)this.delegate).isObserving();
        }

        @Override
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            ((SCMHeadObserver)this.delegate).observe(head, revision);
        }

        @Override
        public Set<SCMHead> getIncludes() {
            return ((SCMHeadObserver)this.delegate).getIncludes();
        }
    }

    public static class Any
    extends SCMHeadObserver {
        @CheckForNull
        private SCMRevision revision;

        public SCMRevision getRevision() {
            return this.revision;
        }

        @CheckForNull
        public SCMRevision result() {
            return this.revision;
        }

        @Override
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            this.revision = revision;
        }

        @Override
        public boolean isObserving() {
            return this.revision == null;
        }
    }

    public static class Named
    extends SCMHeadObserver {
        @NonNull
        private final String head;
        @CheckForNull
        private SCMRevision revision;

        public Named(@NonNull String head) {
            head.getClass();
            this.head = head;
        }

        @CheckForNull
        public SCMRevision result() {
            return this.revision;
        }

        @Override
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            if (this.head.equals(head.getName())) {
                this.revision = revision;
            }
        }

        @Override
        public boolean isObserving() {
            return this.revision == null;
        }
    }

    public static class Selector
    extends SCMHeadObserver {
        @NonNull
        private final SCMHead head;
        @CheckForNull
        private SCMRevision revision;

        public Selector(@NonNull SCMHead head) {
            head.getClass();
            this.head = head;
        }

        @CheckForNull
        public SCMRevision result() {
            return this.revision;
        }

        @Override
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            if (this.head.equals(head)) {
                this.revision = revision;
            }
        }

        @Override
        public boolean isObserving() {
            return this.revision == null;
        }

        @Override
        public Set<SCMHead> getIncludes() {
            return Collections.singleton(this.head);
        }
    }

    public static class Collector
    extends SCMHeadObserver {
        @NonNull
        private final Map<SCMHead, SCMRevision> result = new TreeMap<SCMHead, SCMRevision>();

        @Override
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            this.result.put(head, revision);
        }

        @NonNull
        public Map<SCMHead, SCMRevision> result() {
            return this.result;
        }
    }

    public static class OneFinished
    extends SCMHeadObserver {
        @GuardedBy(value="this")
        private Set<SCMHead> includes = null;
        @GuardedBy(value="this")
        private boolean includesPopulated;
        @NonNull
        private final Iterable<SCMHeadObserver> observers;

        public OneFinished(SCMHeadObserver ... observers) {
            this(Arrays.asList(observers));
        }

        public OneFinished(@NonNull Iterable<SCMHeadObserver> observers) {
            observers.getClass();
            this.observers = observers;
        }

        @Override
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            for (SCMHeadObserver observer : this.observers) {
                if (!observer.isObserving()) continue;
                observer.observe(head, revision);
            }
        }

        @Override
        public boolean isObserving() {
            for (SCMHeadObserver observer : this.observers) {
                if (observer.isObserving()) continue;
                return false;
            }
            return true;
        }

        @Override
        public synchronized Set<SCMHead> getIncludes() {
            if (this.includesPopulated) {
                return this.includes;
            }
            HashSet<SCMHead> result = null;
            for (SCMHeadObserver observer : this.observers) {
                Set<SCMHead> includes = observer.getIncludes();
                if (includes == null) {
                    this.includes = null;
                    this.includesPopulated = true;
                    return null;
                }
                if (result == null) {
                    result = new HashSet<SCMHead>(includes);
                    continue;
                }
                result.addAll(includes);
            }
            this.includes = result;
            this.includesPopulated = true;
            return result;
        }
    }

    public static class AllFinished
    extends SCMHeadObserver {
        @GuardedBy(value="this")
        private Set<SCMHead> includes = null;
        @GuardedBy(value="this")
        private boolean includesPopulated;
        @NonNull
        private final Iterable<SCMHeadObserver> observers;

        public AllFinished(SCMHeadObserver ... observers) {
            this(Arrays.asList(observers));
        }

        public AllFinished(@NonNull Iterable<SCMHeadObserver> observers) {
            observers.getClass();
            this.observers = observers;
        }

        @Override
        public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
            for (SCMHeadObserver observer : this.observers) {
                if (!observer.isObserving()) continue;
                observer.observe(head, revision);
            }
        }

        @Override
        public boolean isObserving() {
            for (SCMHeadObserver observer : this.observers) {
                if (!observer.isObserving()) continue;
                return true;
            }
            return false;
        }

        @Override
        public synchronized Set<SCMHead> getIncludes() {
            if (this.includesPopulated) {
                return this.includes;
            }
            HashSet<SCMHead> result = null;
            for (SCMHeadObserver observer : this.observers) {
                Set<SCMHead> includes = observer.getIncludes();
                if (includes == null) {
                    this.includes = null;
                    this.includesPopulated = true;
                    return null;
                }
                if (result == null) {
                    result = new HashSet<SCMHead>(includes);
                    continue;
                }
                result.addAll(includes);
            }
            this.includes = result;
            this.includesPopulated = true;
            return result;
        }
    }
}

