/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.scm.SCM;
import java.io.IOException;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;

public abstract class SCMFileSystem {
    @CheckForNull
    private final SCMRevision rev;

    protected SCMFileSystem(@CheckForNull SCMRevision rev) {
        this.rev = rev;
    }

    @CheckForNull
    public SCMRevision getRevision() {
        return this.rev;
    }

    public final boolean isFixedRevision() {
        return this.getRevision() != null;
    }

    @CheckForNull
    public final SCMFile get(@NonNull String path) throws IOException {
        return this.getRoot().get(path);
    }

    @NonNull
    public abstract SCMFile getRoot() throws IOException;

    @CheckForNull
    public static SCMFileSystem of(@NonNull SCM scm) {
        return SCMFileSystem.of(scm, null);
    }

    @CheckForNull
    public static SCMFileSystem of(@NonNull SCM scm, @CheckForNull SCMRevision rev) {
        scm.getClass();
        SCMFileSystem fallBack = null;
        for (Builder b : ExtensionList.lookup(Builder.class)) {
            SCMFileSystem inspector = b.build(scm, rev);
            if (inspector == null) continue;
            if (inspector.isFixedRevision()) {
                return inspector;
            }
            if (fallBack != null) continue;
            fallBack = inspector;
        }
        return fallBack;
    }

    @CheckForNull
    public static SCMFileSystem of(@NonNull SCMSource source, @NonNull SCMHead head) {
        return SCMFileSystem.of(source, head, null);
    }

    @CheckForNull
    public static SCMFileSystem of(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) {
        ((Object)((Object)source)).getClass();
        SCMFileSystem fallBack = null;
        for (Builder b : ExtensionList.lookup(Builder.class)) {
            SCMFileSystem inspector = b.build(source, head, rev);
            if (inspector == null) continue;
            if (inspector.isFixedRevision()) {
                return inspector;
            }
            if (fallBack != null) continue;
            fallBack = inspector;
        }
        return fallBack;
    }

    public static abstract class Builder
    implements ExtensionPoint {
        @CheckForNull
        public abstract SCMFileSystem build(@NonNull SCM var1, @CheckForNull SCMRevision var2);

        @CheckForNull
        public SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) {
            return this.build(source.build(head, rev), rev);
        }
    }
}

